"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldFinalEdit = FieldFinalEdit;
var _react = _interopRequireDefault(require("react"));
var _utility_types = require("../../../../../../../common/utility_types");
var _fields = require("../../../../model/prebuilt_rule_upgrade/fields");
var _field_upgrade_context = require("../rule_upgrade/field_upgrade_context");
var _common_rule_field_edit = require("./common_rule_field_edit");
var _custom_query_rule_field_edit = require("./custom_query_rule_field_edit");
var _saved_query_rule_field_edit = require("./saved_query_rule_field_edit");
var _threat_match_rule_field_edit = require("./threat_match_rule_field_edit");
var _threshold_rule_field_edit = require("./threshold_rule_field_edit");
var _new_terms_rule_field_edit = require("./new_terms_rule_field_edit");
var _eql_rule_field_edit = require("./eql_rule_field_edit");
var _esql_rule_field_edit = require("./esql_rule_field_edit");
var _machine_learning_rule_field_edit = require("./machine_learning_rule_field_edit");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/three_way_diff/final_edit/field_final_edit.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function FieldFinalEdit() {
  const {
    fieldName,
    finalDiffableRule: {
      type: ruleType
    }
  } = (0, _field_upgrade_context.useFieldUpgradeContext)();
  if ((0, _fields.isCommonFieldName)(fieldName)) {
    return /*#__PURE__*/_react.default.createElement(_common_rule_field_edit.CommonRuleFieldEdit, {
      fieldName: fieldName,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 39,
        columnNumber: 12
      }
    });
  }
  switch (ruleType) {
    case 'query':
      return /*#__PURE__*/_react.default.createElement(_custom_query_rule_field_edit.CustomQueryRuleFieldEdit, {
        fieldName: fieldName,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 44,
          columnNumber: 14
        }
      });
    case 'saved_query':
      return /*#__PURE__*/_react.default.createElement(_saved_query_rule_field_edit.SavedQueryRuleFieldEdit, {
        fieldName: fieldName,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 46,
          columnNumber: 14
        }
      });
    case 'eql':
      return /*#__PURE__*/_react.default.createElement(_eql_rule_field_edit.EqlRuleFieldEdit, {
        fieldName: fieldName,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 48,
          columnNumber: 14
        }
      });
    case 'esql':
      return /*#__PURE__*/_react.default.createElement(_esql_rule_field_edit.EsqlRuleFieldEdit, {
        fieldName: fieldName,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 50,
          columnNumber: 14
        }
      });
    case 'threat_match':
      return /*#__PURE__*/_react.default.createElement(_threat_match_rule_field_edit.ThreatMatchRuleFieldEdit, {
        fieldName: fieldName,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 52,
          columnNumber: 14
        }
      });
    case 'threshold':
      return /*#__PURE__*/_react.default.createElement(_threshold_rule_field_edit.ThresholdRuleFieldEdit, {
        fieldName: fieldName,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 54,
          columnNumber: 14
        }
      });
    case 'machine_learning':
      return /*#__PURE__*/_react.default.createElement(_machine_learning_rule_field_edit.MachineLearningRuleFieldEdit, {
        fieldName: fieldName,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 57,
          columnNumber: 9
        }
      });
    case 'new_terms':
      return /*#__PURE__*/_react.default.createElement(_new_terms_rule_field_edit.NewTermsRuleFieldEdit, {
        fieldName: fieldName,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 60,
          columnNumber: 14
        }
      });
    default:
      return (0, _utility_types.assertUnreachable)(ruleType);
  }
}