"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSubfieldChangesForEqlQuery = void 0;
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSubfieldChangesForEqlQuery = (oldFieldValue, newFieldValue) => {
  const changes = [];
  const subFieldNames = ['query', 'filters', 'event_category_override', 'tiebreaker_field', 'timestamp_field'];
  for (const subFieldName of subFieldNames) {
    const oldValue = (0, _utils.stringifyToSortedJson)(oldFieldValue === null || oldFieldValue === void 0 ? void 0 : oldFieldValue[subFieldName]);
    const newValue = (0, _utils.stringifyToSortedJson)(newFieldValue === null || newFieldValue === void 0 ? void 0 : newFieldValue[subFieldName]);
    if (newValue !== oldValue) {
      changes.push({
        subfieldName: subFieldName,
        oldSubfieldValue: oldValue,
        newSubfieldValue: newValue
      });
    }
  }
  return changes;
};
exports.getSubfieldChangesForEqlQuery = getSubfieldChangesForEqlQuery;