"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BACKFILL_TABLE_TITLE = exports.BACKFILL_TABLE_SUBTITLE = exports.BACKFILL_TABLE_REFRESH = exports.BACKFILL_SCHEDULE_SUCCESS = exports.BACKFILL_SCHEDULE_ERROR_TITLE = exports.BACKFILLS_TABLE_STOP_CONFIRMATION_TITLE = exports.BACKFILLS_TABLE_STOP_CONFIRMATION_SUCCESS = exports.BACKFILLS_TABLE_STOP_CONFIRMATION_STOP_RUNS = exports.BACKFILLS_TABLE_STOP_CONFIRMATION_ERROR = exports.BACKFILLS_TABLE_STOP_CONFIRMATION_CANCEL = exports.BACKFILLS_TABLE_STOP_CONFIRMATION_BODY = exports.BACKFILLS_TABLE_STOP = exports.BACKFILLS_TABLE_COLUMN_TOTAL_TOOLTIP = exports.BACKFILLS_TABLE_COLUMN_TOTAL = exports.BACKFILLS_TABLE_COLUMN_STATUS_TOOLTIP = exports.BACKFILLS_TABLE_COLUMN_STATUS = exports.BACKFILLS_TABLE_COLUMN_SOURCE_TIME_RANGE_TOOLTIP = exports.BACKFILLS_TABLE_COLUMN_SOURCE_TIME_RANGE = exports.BACKFILLS_TABLE_COLUMN_RUNNING_TOOLTIP = exports.BACKFILLS_TABLE_COLUMN_RUNNING = exports.BACKFILLS_TABLE_COLUMN_PENDING_TOOLTIP = exports.BACKFILLS_TABLE_COLUMN_PENDING = exports.BACKFILLS_TABLE_COLUMN_ERROR_TOOLTIP = exports.BACKFILLS_TABLE_COLUMN_ERROR = exports.BACKFILLS_TABLE_COLUMN_CREATED_AT_TOOLTIP = exports.BACKFILLS_TABLE_COLUMN_CREATED_AT = exports.BACKFILLS_TABLE_COLUMN_COMPLETED_TOOLTIP = exports.BACKFILLS_TABLE_COLUMN_COMPLETED = exports.BACKFILLS_TABLE_COLUMN_ACTION = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BACKFILLS_TABLE_COLUMN_STATUS = exports.BACKFILLS_TABLE_COLUMN_STATUS = _i18n.i18n.translate('xpack.securitySolution.rule_gaps.backfillsTable.column.status', {
  defaultMessage: 'Status'
});
const BACKFILLS_TABLE_COLUMN_STATUS_TOOLTIP = exports.BACKFILLS_TABLE_COLUMN_STATUS_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.rule_gaps.backfillsTable.column.statusTooltip', {
  defaultMessage: 'Overall status of execution'
});
const BACKFILLS_TABLE_COLUMN_CREATED_AT = exports.BACKFILLS_TABLE_COLUMN_CREATED_AT = _i18n.i18n.translate('xpack.securitySolution.rule_gaps.backfillsTable.column.createdAt', {
  defaultMessage: 'Created at'
});
const BACKFILLS_TABLE_COLUMN_CREATED_AT_TOOLTIP = exports.BACKFILLS_TABLE_COLUMN_CREATED_AT_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.rule_gaps.backfillsTable.column.createdAtTooltip', {
  defaultMessage: 'When the manual run started'
});
const BACKFILLS_TABLE_COLUMN_SOURCE_TIME_RANGE = exports.BACKFILLS_TABLE_COLUMN_SOURCE_TIME_RANGE = _i18n.i18n.translate('xpack.securitySolution.rule_gaps.backfillsTable.column.sourceTimeRange', {
  defaultMessage: 'Source event time range'
});
const BACKFILLS_TABLE_COLUMN_SOURCE_TIME_RANGE_TOOLTIP = exports.BACKFILLS_TABLE_COLUMN_SOURCE_TIME_RANGE_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.rule_gaps.backfillsTable.column.sourceTimeRangeTooltip', {
  defaultMessage: 'The date and time range selected for the manual run'
});
const BACKFILLS_TABLE_COLUMN_ERROR = exports.BACKFILLS_TABLE_COLUMN_ERROR = _i18n.i18n.translate('xpack.securitySolution.rule_gaps.backfillsTable.column.error', {
  defaultMessage: 'Error'
});
const BACKFILLS_TABLE_COLUMN_ERROR_TOOLTIP = exports.BACKFILLS_TABLE_COLUMN_ERROR_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.rule_gaps.backfillsTable.column.errorTooltip', {
  defaultMessage: 'The number of failed manual run rule executions'
});
const BACKFILLS_TABLE_COLUMN_COMPLETED = exports.BACKFILLS_TABLE_COLUMN_COMPLETED = _i18n.i18n.translate('xpack.securitySolution.rule_gaps.backfillsTable.column.completed', {
  defaultMessage: 'Completed'
});
const BACKFILLS_TABLE_COLUMN_COMPLETED_TOOLTIP = exports.BACKFILLS_TABLE_COLUMN_COMPLETED_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.rule_gaps.backfillsTable.column.completedTooltip', {
  defaultMessage: 'The number of completed manual run rule executions'
});
const BACKFILLS_TABLE_COLUMN_RUNNING = exports.BACKFILLS_TABLE_COLUMN_RUNNING = _i18n.i18n.translate('xpack.securitySolution.rule_gaps.backfillsTable.column.running', {
  defaultMessage: 'Running'
});
const BACKFILLS_TABLE_COLUMN_RUNNING_TOOLTIP = exports.BACKFILLS_TABLE_COLUMN_RUNNING_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.rule_gaps.backfillsTable.column.runningTooltip', {
  defaultMessage: 'The number of manual run rule executions that are in progress'
});
const BACKFILLS_TABLE_COLUMN_PENDING = exports.BACKFILLS_TABLE_COLUMN_PENDING = _i18n.i18n.translate('xpack.securitySolution.rule_gaps.backfillsTable.column.pending', {
  defaultMessage: 'Pending'
});
const BACKFILLS_TABLE_COLUMN_PENDING_TOOLTIP = exports.BACKFILLS_TABLE_COLUMN_PENDING_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.rule_gaps.backfillsTable.column.pendingTooltip', {
  defaultMessage: 'The number of manual run rule executions that are waiting to execute'
});
const BACKFILLS_TABLE_COLUMN_TOTAL = exports.BACKFILLS_TABLE_COLUMN_TOTAL = _i18n.i18n.translate('xpack.securitySolution.rule_gaps.backfillsTable.column.total', {
  defaultMessage: 'Total'
});
const BACKFILLS_TABLE_COLUMN_TOTAL_TOOLTIP = exports.BACKFILLS_TABLE_COLUMN_TOTAL_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.rule_gaps.backfillsTable.column.totalTooltip', {
  defaultMessage: 'The total number of rule executions that will occur during the selected date and time range'
});
const BACKFILLS_TABLE_STOP = exports.BACKFILLS_TABLE_STOP = _i18n.i18n.translate('xpack.securitySolution.rule_gaps.backfillsTable.stop', {
  defaultMessage: 'Stop run'
});
const BACKFILLS_TABLE_STOP_CONFIRMATION_TITLE = exports.BACKFILLS_TABLE_STOP_CONFIRMATION_TITLE = _i18n.i18n.translate('xpack.securitySolution.rule_gaps.backfillsTable.stop.confirmationTitle', {
  defaultMessage: 'Stop this rule run'
});
const BACKFILLS_TABLE_STOP_CONFIRMATION_CANCEL = exports.BACKFILLS_TABLE_STOP_CONFIRMATION_CANCEL = _i18n.i18n.translate('xpack.securitySolution.rule_gaps.backfillsTable.stop.cancel', {
  defaultMessage: 'Cancel'
});
const BACKFILLS_TABLE_STOP_CONFIRMATION_STOP_RUNS = exports.BACKFILLS_TABLE_STOP_CONFIRMATION_STOP_RUNS = _i18n.i18n.translate('xpack.securitySolution.rule_gaps.backfillsTable.stop.stopRuns', {
  defaultMessage: 'Stop run'
});
const BACKFILLS_TABLE_STOP_CONFIRMATION_BODY = exports.BACKFILLS_TABLE_STOP_CONFIRMATION_BODY = _i18n.i18n.translate('xpack.securitySolution.rule_gaps.backfillsTable.stop.description', {
  defaultMessage: 'All the pending rule executions for this manual rule run will be stopped'
});
const BACKFILLS_TABLE_STOP_CONFIRMATION_SUCCESS = exports.BACKFILLS_TABLE_STOP_CONFIRMATION_SUCCESS = _i18n.i18n.translate('xpack.securitySolution.rule_gaps.backfillsTable.stop.confirmationSuccess', {
  defaultMessage: 'Rule run stopped'
});
const BACKFILLS_TABLE_STOP_CONFIRMATION_ERROR = exports.BACKFILLS_TABLE_STOP_CONFIRMATION_ERROR = _i18n.i18n.translate('xpack.securitySolution.rule_gaps.backfillsTable.stop.confirmationError', {
  defaultMessage: 'Error stopping rule run'
});
const BACKFILL_TABLE_TITLE = exports.BACKFILL_TABLE_TITLE = _i18n.i18n.translate('xpack.securitySolution.rule_gaps.backfillTable.title', {
  defaultMessage: 'Manual runs'
});
const BACKFILL_TABLE_REFRESH = exports.BACKFILL_TABLE_REFRESH = _i18n.i18n.translate('xpack.securitySolution.rule_gaps.backfillTable.refresh', {
  defaultMessage: 'Refresh'
});
const BACKFILL_TABLE_SUBTITLE = exports.BACKFILL_TABLE_SUBTITLE = _i18n.i18n.translate('xpack.securitySolution.rule_gaps.backfillTable.subtitle', {
  defaultMessage: 'View and manage active manual runs'
});
const BACKFILL_SCHEDULE_SUCCESS = numRules => _i18n.i18n.translate('xpack.securitySolution.containers.detectionEngine.backfillSchedule.scheduleRuleRunSuccessTitle', {
  values: {
    numRules
  },
  defaultMessage: 'Successfully scheduled manual run for {numRules, plural, =1 {# rule} other {# rules}}'
});
exports.BACKFILL_SCHEDULE_SUCCESS = BACKFILL_SCHEDULE_SUCCESS;
const BACKFILL_SCHEDULE_ERROR_TITLE = exports.BACKFILL_SCHEDULE_ERROR_TITLE = _i18n.i18n.translate('xpack.securitySolution.containers.detectionEngine.backfillSchedule.scheduleRuleRunErrorTitle', {
  defaultMessage: 'Error while scheduling manual run'
});
const BACKFILLS_TABLE_COLUMN_ACTION = exports.BACKFILLS_TABLE_COLUMN_ACTION = _i18n.i18n.translate('xpack.securitySolution.rule_gaps.backfillsTable.column.action', {
  defaultMessage: 'Action'
});