"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RULE_EXCEPTION = exports.OPERATING_SYSTEM_WINDOWS_AND_MAC = exports.OPERATING_SYSTEM_WINDOWS = exports.OPERATING_SYSTEM_MAC = exports.OPERATING_SYSTEM_LINUX = exports.OPERATING_SYSTEM_LABEL = exports.MODAL_ERROR_ACCORDION_TEXT = exports.ERROR_FETCHING_REFERENCES_TITLE = exports.ERROR = exports.ENDPOINT_EXCEPTION = exports.DISASSOCIATE_LIST_SUCCESS = exports.DISASSOCIATE_EXCEPTION_LIST_ERROR = exports.COMMENT_EVENT = exports.COMMENTS_SHOW = exports.COMMENTS_HIDE = exports.CLEAR_EXCEPTIONS_LABEL = exports.CANCEL = exports.ADD_TO_ENDPOINT_LIST = exports.ADD_TO_DETECTIONS_LIST = exports.ADD_TO_CLIPBOARD = exports.ADD_EXCEPTION_FETCH_ERROR = exports.ADD_EXCEPTION_FETCH_404_ERROR = exports.ADD_COMMENT_PLACEHOLDER = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const COMMENTS_SHOW = comments => _i18n.i18n.translate('xpack.securitySolution.exceptions.showCommentsLabel', {
  values: {
    comments
  },
  defaultMessage: 'Show ({comments}) {comments, plural, =1 {Comment} other {Comments}}'
});
exports.COMMENTS_SHOW = COMMENTS_SHOW;
const COMMENTS_HIDE = comments => _i18n.i18n.translate('xpack.securitySolution.exceptions.hideCommentsLabel', {
  values: {
    comments
  },
  defaultMessage: 'Hide ({comments}) {comments, plural, =1 {Comment} other {Comments}}'
});
exports.COMMENTS_HIDE = COMMENTS_HIDE;
const COMMENT_EVENT = exports.COMMENT_EVENT = _i18n.i18n.translate('xpack.securitySolution.exceptions.commentEventLabel', {
  defaultMessage: 'added a comment'
});
const OPERATING_SYSTEM_LABEL = exports.OPERATING_SYSTEM_LABEL = _i18n.i18n.translate('xpack.securitySolution.exceptions.operatingSystemFullLabel', {
  defaultMessage: 'Operating System'
});
const ADD_TO_ENDPOINT_LIST = exports.ADD_TO_ENDPOINT_LIST = _i18n.i18n.translate('xpack.securitySolution.exceptions.viewer.addToEndpointListLabel', {
  defaultMessage: 'Add endpoint exception'
});
const ADD_TO_DETECTIONS_LIST = exports.ADD_TO_DETECTIONS_LIST = _i18n.i18n.translate('xpack.securitySolution.exceptions.viewer.addToDetectionsListLabel', {
  defaultMessage: 'Add rule exception'
});
const ADD_COMMENT_PLACEHOLDER = exports.ADD_COMMENT_PLACEHOLDER = _i18n.i18n.translate('xpack.securitySolution.exceptions.viewer.addCommentPlaceholder', {
  defaultMessage: 'Add a new comment...'
});
const ADD_TO_CLIPBOARD = exports.ADD_TO_CLIPBOARD = _i18n.i18n.translate('xpack.securitySolution.exceptions.viewer.addToClipboard', {
  defaultMessage: 'Comment'
});
const CLEAR_EXCEPTIONS_LABEL = exports.CLEAR_EXCEPTIONS_LABEL = _i18n.i18n.translate('xpack.securitySolution.exceptions.clearExceptionsLabel', {
  defaultMessage: 'Remove Exception List'
});
const ADD_EXCEPTION_FETCH_404_ERROR = listId => _i18n.i18n.translate('xpack.securitySolution.exceptions.fetch404Error', {
  values: {
    listId
  },
  defaultMessage: 'The associated exception list ({listId}) no longer exists. Please remove the missing exception list to add additional exceptions to the detection rule.'
});
exports.ADD_EXCEPTION_FETCH_404_ERROR = ADD_EXCEPTION_FETCH_404_ERROR;
const ADD_EXCEPTION_FETCH_ERROR = exports.ADD_EXCEPTION_FETCH_ERROR = _i18n.i18n.translate('xpack.securitySolution.exceptions.fetchError', {
  defaultMessage: 'Error fetching exception list'
});
const ERROR = exports.ERROR = _i18n.i18n.translate('xpack.securitySolution.exceptions.errorLabel', {
  defaultMessage: 'Error'
});
const CANCEL = exports.CANCEL = _i18n.i18n.translate('xpack.securitySolution.exceptions.cancelLabel', {
  defaultMessage: 'Cancel'
});
const MODAL_ERROR_ACCORDION_TEXT = exports.MODAL_ERROR_ACCORDION_TEXT = _i18n.i18n.translate('xpack.securitySolution.exceptions.modalErrorAccordionText', {
  defaultMessage: 'Show rule reference information:'
});
const DISASSOCIATE_LIST_SUCCESS = id => _i18n.i18n.translate('xpack.securitySolution.exceptions.disassociateListSuccessText', {
  values: {
    id
  },
  defaultMessage: 'Exception list ({id}) has successfully been removed'
});
exports.DISASSOCIATE_LIST_SUCCESS = DISASSOCIATE_LIST_SUCCESS;
const DISASSOCIATE_EXCEPTION_LIST_ERROR = exports.DISASSOCIATE_EXCEPTION_LIST_ERROR = _i18n.i18n.translate('xpack.securitySolution.exceptions.disassociateExceptionListError', {
  defaultMessage: 'Failed to remove exception list'
});
const OPERATING_SYSTEM_WINDOWS = exports.OPERATING_SYSTEM_WINDOWS = _i18n.i18n.translate('xpack.securitySolution.exceptions.operatingSystemWindows', {
  defaultMessage: 'Windows'
});
const OPERATING_SYSTEM_MAC = exports.OPERATING_SYSTEM_MAC = _i18n.i18n.translate('xpack.securitySolution.exceptions.operatingSystemMac', {
  defaultMessage: 'macOS'
});
const OPERATING_SYSTEM_WINDOWS_AND_MAC = exports.OPERATING_SYSTEM_WINDOWS_AND_MAC = _i18n.i18n.translate('xpack.securitySolution.exceptions.operatingSystemWindowsAndMac', {
  defaultMessage: 'Windows and macOS'
});
const OPERATING_SYSTEM_LINUX = exports.OPERATING_SYSTEM_LINUX = _i18n.i18n.translate('xpack.securitySolution.exceptions.operatingSystemLinux', {
  defaultMessage: 'Linux'
});
const ERROR_FETCHING_REFERENCES_TITLE = exports.ERROR_FETCHING_REFERENCES_TITLE = _i18n.i18n.translate('xpack.securitySolution.exceptions.fetchingReferencesErrorToastTitle', {
  defaultMessage: 'Error fetching exception references'
});
const RULE_EXCEPTION = exports.RULE_EXCEPTION = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.addException.ruleException', {
  defaultMessage: 'rule exception'
});
const ENDPOINT_EXCEPTION = exports.ENDPOINT_EXCEPTION = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.addException.endpointException', {
  defaultMessage: 'endpoint exception'
});