"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFindExceptionListReferences = void 0;
var _react = require("react");
var _api = require("../../rule_management/api/api");
var _kibana = require("../../../common/lib/kibana");
var i18n = _interopRequireWildcard(require("../utils/translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook for finding what rules are referenced by a set of exception lists
 */
const useFindExceptionListReferences = () => {
  const toasts = (0, _kibana.useToasts)();
  const [isLoading, setIsLoading] = (0, _react.useState)(true);
  const [didError, setError] = (0, _react.useState)(false);
  const [references, setReferences] = (0, _react.useState)(null);
  const findExceptionListAndReferencesRef = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    let isSubscribed = true;
    const abortCtrl = new AbortController();
    const findReferences = async listsToFetch => {
      try {
        setIsLoading(true);
        const {
          references: referencesResults
        } = await (0, _api.findRuleExceptionReferences)({
          lists: listsToFetch,
          signal: abortCtrl.signal
        });
        const results = referencesResults.reduce((acc, result) => {
          const [[key, value]] = Object.entries(result);
          acc[key] = value;
          return acc;
        }, {});
        if (isSubscribed) {
          setIsLoading(false);
          setError(false);
          setReferences(results);
        }
      } catch (error) {
        if (isSubscribed) {
          setError(true);
          setIsLoading(false);
          toasts.addError(error, {
            title: i18n.ERROR_FETCHING_REFERENCES_TITLE
          });
        }
      }
    };
    findExceptionListAndReferencesRef.current = findReferences;
    return () => {
      isSubscribed = false;
      abortCtrl.abort();
    };
  }, [toasts]);
  return [isLoading, didError, references, findExceptionListAndReferencesRef.current];
};
exports.useFindExceptionListReferences = useFindExceptionListReferences;