"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.shouldDisableBulkClose = exports.entryHasNonEcsType = exports.entryHasListType = void 0;
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
var _securitysolutionListUtils = require("@kbn/securitysolution-list-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Determines if item entries has 'is in list'/'is not in list' entry
 */
const entryHasListType = exceptionItems => {
  for (const {
    entries
  } of exceptionItems) {
    for (const exceptionEntry of entries !== null && entries !== void 0 ? entries : []) {
      if ((0, _securitysolutionListUtils.getOperatorType)(exceptionEntry) === _securitysolutionIoTsListTypes.ListOperatorTypeEnum.LIST) {
        return true;
      }
    }
  }
  return false;
};

/**
 * Determines whether or not any entries within the given exceptionItems contain values not in the specified ECS mapping
 */
exports.entryHasListType = entryHasListType;
const entryHasNonEcsType = (exceptionItems, indexPatterns) => {
  const doesFieldNameExist = exceptionEntry => {
    return indexPatterns.fields.some(({
      name
    }) => name === exceptionEntry.field);
  };
  if (exceptionItems.length === 0) {
    return false;
  }
  for (const {
    entries
  } of exceptionItems) {
    for (const exceptionEntry of entries !== null && entries !== void 0 ? entries : []) {
      if (exceptionEntry.type === 'nested') {
        for (const nestedExceptionEntry of exceptionEntry.entries) {
          if (doesFieldNameExist(nestedExceptionEntry) === false) {
            return true;
          }
        }
      } else if (doesFieldNameExist(exceptionEntry) === false) {
        return true;
      }
    }
  }
  return false;
};

/**
 * Determines whether the bulk close alerts option should be disabled.
 */
exports.entryHasNonEcsType = entryHasNonEcsType;
const shouldDisableBulkClose = ({
  items,
  signalIndexPatterns
}) => {
  return entryHasListType(items) || entryHasNonEcsType(items, signalIndexPatterns) || items.every(item => item.entries.length === 0);
};
exports.shouldDisableBulkClose = shouldDisableBulkClose;