"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAddToRulesTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var myI18n = _interopRequireWildcard(require("./translations"));
var commonI18n = _interopRequireWildcard(require("../translations"));
var _utils = require("../utils");
var _link_rule_switch = require("./link_rule_switch");
var _use_find_rules = require("../../../../rule_management/logic/use_find_rules");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_exceptions/components/flyout_components/add_to_rules_table/use_add_to_rules_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useAddToRulesTable = ({
  initiallySelectedRules,
  onRuleSelectionChange
}) => {
  const {
    data: {
      rules
    } = {
      rules: [],
      total: 0
    },
    isFetched
  } = (0, _use_find_rules.useFindRules)({
    filterOptions: {
      filter: '',
      showCustomRules: false,
      showElasticRules: false,
      tags: []
    },
    sortingOptions: undefined,
    pagination: {
      page: 1,
      perPage: 10000
    }
  });
  const [pagination, setPagination] = (0, _react.useState)({
    pageIndex: 0,
    initialPageSize: 25,
    showPerPageOptions: false
  });
  const [linkedRules, setLinkedRules] = (0, _react.useState)(initiallySelectedRules || []);
  (0, _react.useEffect)(() => {
    onRuleSelectionChange(linkedRules);
  }, [linkedRules, onRuleSelectionChange]);
  const sortedRulesByLinkedRulesOnTop = (0, _react.useMemo)(() => (0, _lodash.sortBy)(rules, [rule => {
    return initiallySelectedRules === null || initiallySelectedRules === void 0 ? void 0 : initiallySelectedRules.find(initRule => initRule.id === rule.id);
  }]), [initiallySelectedRules, rules]);
  const tagOptions = (0, _react.useMemo)(() => {
    const uniqueTags = sortedRulesByLinkedRulesOnTop.reduce((acc, item) => {
      const {
        tags
      } = item;
      tags.forEach(tag => acc.add(tag));
      return acc;
    }, new Set());
    return Array.from(uniqueTags).map(tag => ({
      value: tag,
      name: tag,
      field: 'tags'
    }));
  }, [sortedRulesByLinkedRulesOnTop]);
  const searchOptions = (0, _react.useMemo)(() => ({
    box: {
      incremental: true,
      schema: true
    },
    filters: [{
      type: 'field_value_selection',
      operator: 'exact',
      name: _i18n.i18n.translate('xpack.securitySolution.exceptions.addToRulesTable.tagsFilterLabel', {
        defaultMessage: 'Tags'
      }),
      multiSelect: 'or',
      options: tagOptions
    }]
  }), [tagOptions]);
  const rulesTableColumnsWithLinkSwitch = (0, _react.useMemo)(() => [{
    field: 'link',
    name: commonI18n.LINK_COLUMN,
    align: 'left',
    'data-test-subj': 'ruleActionLinkRuleSwitch',
    render: (_, rule) => /*#__PURE__*/_react.default.createElement(_link_rule_switch.LinkRuleSwitch, {
      rule: rule,
      linkedRules: linkedRules,
      onRuleLinkChange: setLinkedRules,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 11
      }
    })
  }, ...(0, _utils.getRulesTableColumn)()], [linkedRules]);
  const onTableChange = (0, _react.useCallback)(({
    page: {
      index
    }
  }) => setPagination({
    ...pagination,
    pageIndex: index
  }), [pagination]);
  return {
    isLoading: !isFetched,
    pagination,
    searchOptions,
    sortedRulesByLinkedRulesOnTop,
    rulesTableColumnsWithLinkSwitch,
    addToSelectedRulesDescription: myI18n.ADD_TO_SELECTED_RULES_DESCRIPTION,
    onTableChange
  };
};
exports.useAddToRulesTable = useAddToRulesTable;