"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAddToSharedListTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
var _api = require("../../../../../exceptions/api");
var i18n = _interopRequireWildcard(require("./translations"));
var commoni18n = _interopRequireWildcard(require("../translations"));
var _link_list_switch = require("./link_list_switch");
var _utils = require("../utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_exceptions/components/flyout_components/add_to_lists_table/use_add_to_lists_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useAddToSharedListTable = ({
  showAllSharedLists,
  sharedExceptionLists,
  onListSelectionChange
}) => {
  const [listsToDisplay, setListsToDisplay] = (0, _react.useState)([]);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const listsToFetch = (0, _react.useMemo)(() => {
    return showAllSharedLists ? [] : sharedExceptionLists;
  }, [showAllSharedLists, sharedExceptionLists]);

  // here we don't have initial selected lists as they component is used only in the Add Exception Flyout
  const [linkedLists, setLinkedLists] = (0, _react.useState)([]);
  const [pagination, setPagination] = (0, _react.useState)({
    pageIndex: 0,
    initialPageSize: 5,
    showPerPageOptions: false
  });
  const [error, setError] = (0, _react.useState)(undefined);
  const getReferences = (0, _react.useCallback)(async () => {
    try {
      setIsLoading(true);
      return (0, _api.getExceptionItemsReferences)(!listsToFetch.length ? [{
        namespace_type: 'single'
      }] : listsToFetch);
    } catch (err) {
      setError(i18n.REFERENCES_FETCH_ERROR);
    }
  }, [listsToFetch]);
  const fillListsToDisplay = (0, _react.useCallback)(async () => {
    const result = await getReferences();
    if (!result) {
      return setIsLoading(false);
    }
    const lists = [];
    for (const value of Object.values(result)) if (value.type === _securitysolutionIoTsListTypes.ExceptionListTypeEnum.DETECTION) lists.push(value);
    setListsToDisplay(lists);
    setIsLoading(false);
  }, [getReferences]);
  (0, _react.useEffect)(() => {
    fillListsToDisplay();
  }, [listsToFetch, getReferences, fillListsToDisplay]);
  (0, _react.useEffect)(() => {
    onListSelectionChange(linkedLists.map(({
      referenced_rules: _,
      namespace_type: namespaceType,
      os_types: osTypes,
      tags,
      ...rest
    }) => ({
      ...rest,
      namespace_type: namespaceType !== null && namespaceType !== void 0 ? namespaceType : 'single',
      os_types: osTypes !== null && osTypes !== void 0 ? osTypes : [],
      tags: tags !== null && tags !== void 0 ? tags : []
    })));
  }, [linkedLists, onListSelectionChange]);
  const listTableColumnsWithLinkSwitch = (0, _react.useMemo)(() => [{
    field: 'link',
    name: commoni18n.LINK_COLUMN,
    align: 'left',
    'data-test-subj': 'ruleActionLinkRuleSwitch',
    render: (_, rule) => /*#__PURE__*/_react.default.createElement(_link_list_switch.LinkListSwitch, {
      dataTestSubj: "addToSharedListSwitch",
      list: rule,
      linkedList: linkedLists,
      onListLinkChange: setLinkedLists,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 11
      }
    })
  }, ...(0, _utils.getSharedListsTableColumns)()], [linkedLists]);
  const onTableChange = (0, _react.useCallback)(({
    page: {
      index
    }
  }) => setPagination({
    ...pagination,
    pageIndex: index
  }), [pagination]);
  return {
    error,
    isLoading,
    pagination,
    lists: listsToDisplay,
    listTableColumnsWithLinkSwitch,
    addToSelectedListDescription: i18n.ADD_TO_LISTS_DESCRIPTION,
    onTableChange
  };
};
exports.useAddToSharedListTable = useAddToSharedListTable;