"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.threatMatchMappingValidatorFactory = threatMatchMappingValidatorFactory;
var _i18n = require("@kbn/i18n");
var _helpers = require("../../../common/components/threat_match/helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function threatMatchMappingValidatorFactory() {
  return (...args) => {
    const [{
      path,
      value
    }] = args;
    if ((0, _helpers.singleEntryThreat)(value)) {
      return {
        code: 'ERR_FIELD_MISSING',
        path,
        message: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.customThreatQueryFieldRequiredError', {
          defaultMessage: 'At least one indicator match is required.'
        })
      };
    }
    if ((0, _helpers.containsInvalidItems)(value)) {
      return {
        code: 'ERR_FIELD_MISSING',
        path,
        message: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.customThreatQueryFieldRequiredEmptyError', {
          defaultMessage: 'All matches require both a field and threat index field.'
        })
      };
    }
  };
}