"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepDefineRuleReadOnly = exports.StepDefineRule = exports.MyLabelButton = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _i18nReact = require("@kbn/i18n-react");
var _use_rule_from_timeline = require("../../../../detections/hooks/use_rule_from_timeline");
var _helpers = require("../../../../../common/machine_learning/helpers");
var _helpers2 = require("../../pages/rule_creation/helpers");
var _types = require("../../../common/types");
var _description_step = require("../description_step");
var _query_bar_field = require("../query_bar_field");
var _select_rule_type = require("../select_rule_type");
var _pick_timeline = require("../../../rule_creation/components/pick_timeline");
var _step_content_wrapper = require("../../../rule_creation/components/step_content_wrapper");
var _shared_imports = require("../../../../shared_imports");
var _schema = require("./schema");
var _use_experimental_feature_fields_transform = require("./use_experimental_feature_fields_transform");
var i18n = _interopRequireWildcard(require("./translations"));
var _utils = require("../../../../../common/detection_engine/utils");
var _eql_query_edit = require("../../../rule_creation/components/eql_query_edit");
var _data_view_selector_field = require("../data_view_selector_field");
var _source = require("../../../../common/containers/source");
var _required_fields = require("../../../rule_creation/components/required_fields");
var _doc_link = require("../../../../common/components/links_to_docs/doc_link");
var _use_license = require("../../../../common/hooks/use_license");
var _constants = require("../../../../../common/detection_engine/constants");
var _use_upselling = require("../../../../common/hooks/use_upselling");
var _hooks = require("../../hooks");
var _use_alert_suppression = require("../../../rule_management/logic/use_alert_suppression");
var _ai_assistant = require("../ai_assistant");
var _related_integrations = require("../../../rule_creation/components/related_integrations");
var _use_ml_rule_config = require("../../../../common/components/ml/hooks/use_ml_rule_config");
var _use_terms_aggregation_fields = require("../../../../common/hooks/use_terms_aggregation_fields");
var _alert_suppression_edit = require("../../../rule_creation/components/alert_suppression_edit");
var _threshold_alert_suppression_edit = require("../../../rule_creation/components/threshold_alert_suppression_edit");
var _machine_learning_job_id_edit = require("../../../rule_creation/components/machine_learning_job_id_edit");
var _threshold_edit = require("../../../rule_creation/components/threshold_edit");
var _anomaly_threshold_edit = require("../../../rule_creation/components/anomaly_threshold_edit/anomaly_threshold_edit");
var _history_window_start_edit = require("../../../rule_creation/components/history_window_start_edit");
var _new_terms_fields_edit = require("../../../rule_creation/components/new_terms_fields_edit");
var _esql_query_edit = require("../../../rule_creation/components/esql_query_edit");
var _create_ml_job_button = require("../../../rule_creation/components/create_ml_job_button/create_ml_job_button");
var _threat_match_edit = require("../threat_match_edit");
var _use_persistent_new_terms_state = require("./use_persistent_new_terms_state");
var _use_persistent_alert_suppression_state = require("./use_persistent_alert_suppression_state");
var _use_persistent_threshold_state = require("./use_persistent_threshold_state");
var _use_persistent_query = require("./use_persistent_query");
var _user_privileges = require("../../../../common/components/user_privileges");
var _use_persistent_machine_learning_state = require("./use_persistent_machine_learning_state");
var _use_persistent_threat_match_state = require("./use_persistent_threat_match_state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation_ui/components/step_define_rule/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CommonUseField = (0, _shared_imports.getUseField)({
  component: _shared_imports.Field
});
const StyledVisibleContainer = _styledComponents.default.div`
  display: ${props => props.isVisible ? 'block' : 'none'};
`;
const MyLabelButton = exports.MyLabelButton = (0, _styledComponents.default)(_eui.EuiButtonEmpty)`
  height: 18px;
  font-size: 12px;

  .euiIcon {
    width: 14px;
    height: 14px;
  }
`;
MyLabelButton.defaultProps = {
  flush: 'right'
};
const RuleTypeEuiFormRow = (0, _styledComponents.default)(_eui.EuiFormRow).attrs(({
  $isVisible
}) => ({
  style: {
    display: $isVisible ? 'flex' : 'none'
  }
}))``;
const StepDefineRuleComponent = ({
  dataSourceType,
  defaultSavedQuery,
  form,
  alertSuppressionFields,
  index,
  indexPattern,
  indicesConfig,
  isIndexPatternLoading,
  isLoading,
  isQueryBarValid,
  isUpdateView = false,
  queryBarSavedId,
  queryBarTitle,
  setIsQueryBarValid,
  shouldLoadQueryDynamically,
  threatIndex
}) => {
  var _queryBar$query, _queryBar$query2, _queryBar$query3;
  const [{
    ruleType,
    queryBar,
    machineLearningJobId,
    threshold
  }] = (0, _shared_imports.useFormData)({
    form,
    watch: ['ruleType', 'queryBar', 'machineLearningJobId', 'threshold.field']
  });
  const [openTimelineSearch, setOpenTimelineSearch] = (0, _react.useState)(false);
  const [indexModified, setIndexModified] = (0, _react.useState)(false);
  const license = (0, _use_license.useLicense)();
  const {
    allJobsStarted,
    hasMlAdminPermissions,
    hasMlLicense,
    loading: mlRuleConfigLoading,
    mlSuppressionFields
  } = (0, _use_ml_rule_config.useMLRuleConfig)({
    machineLearningJobId
  });
  const isMlSuppressionIncomplete = (0, _helpers.isMlRule)(ruleType) && machineLearningJobId && (machineLearningJobId === null || machineLearningJobId === void 0 ? void 0 : machineLearningJobId.length) > 0 && !allJobsStarted;
  const isAlertSuppressionLicenseValid = license.isAtLeast(_constants.MINIMUM_LICENSE_FOR_SUPPRESSION);
  const isThresholdRule = (0, _utils.isThresholdRule)(ruleType);
  const alertSuppressionUpsellingMessage = (0, _use_upselling.useUpsellingMessage)('alert_suppression_rule_form');
  const {
    getFields,
    reset,
    setFieldValue
  } = form;
  const {
    timelinePrivileges: {
      read: canAttachTimelineTemplates
    }
  } = (0, _user_privileges.useUserPrivileges)();

  // Callback for when user toggles between Data Views and Index Patterns
  const onChangeDataSource = (0, _react.useCallback)(optionId => {
    form.setFieldValue('dataSourceType', optionId);
    form.getFields().index.reset({
      resetValue: false
    });
    form.getFields().dataViewId.reset({
      resetValue: false
    });
  }, [form]);
  const termsAggregationFields = (0, _use_terms_aggregation_fields.useTermsAggregationFields)(indexPattern.fields);
  const termsAggregationFieldNames = (0, _react.useMemo)(() => termsAggregationFields.map(field => field.name), [termsAggregationFields]);
  const [threatIndexPatternsLoading, {
    indexPatterns: threatIndexPatterns
  }] = (0, _source.useFetchIndex)(threatIndex);

  // reset form when rule type changes
  (0, _react.useEffect)(() => {
    reset({
      resetValues: false
    });
  }, [reset, ruleType]);
  (0, _react.useEffect)(() => {
    setIndexModified(!(0, _lodash.isEqual)(index, indicesConfig));
  }, [index, indicesConfig]);
  const {
    setPersistentEqlQuery,
    setPersistentEqlOptions
  } = (0, _use_persistent_query.usePersistentQuery)({
    form
  });
  (0, _use_persistent_alert_suppression_state.usePersistentAlertSuppressionState)({
    form
  });
  (0, _use_persistent_threshold_state.usePersistentThresholdState)({
    form,
    ruleTypePath: 'ruleType',
    thresholdPath: 'threshold'
  });
  (0, _use_persistent_machine_learning_state.usePersistentMachineLearningState)({
    form,
    ruleTypePath: 'ruleType',
    machineLearningJobIdPath: 'machineLearningJobId',
    anomalyThresholdPath: 'anomalyThreshold'
  });
  (0, _use_persistent_new_terms_state.usePersistentNewTermsState)({
    form,
    ruleTypePath: 'ruleType',
    newTermsFieldsPath: 'newTermsFields',
    historyWindowStartPath: 'historyWindowSize'
  });
  (0, _use_persistent_threat_match_state.usePersistentThreatMatchState)({
    form
  });
  const handleSetRuleFromTimeline = (0, _react.useCallback)(({
    index: timelineIndex,
    queryBar: timelineQueryBar,
    eqlOptions
  }) => {
    const setQuery = () => {
      setFieldValue('index', timelineIndex);
      setFieldValue('queryBar', timelineQueryBar);
    };
    if (timelineQueryBar.query.language === 'eql') {
      setFieldValue('ruleType', 'eql');

      // Rule type change takes as minimum two re-renders. Since we render a specific
      // query editor component depending on rule type we need to first render
      // the rule type specific query editor component (using UseField under the hood) to
      // be able to set query's field value.
      //
      // setTimeout provides a simple solution to wait until the rule type specific query
      // editor component is rendered.
      setTimeout(() => {
        setPersistentEqlQuery(timelineQueryBar);
        setPersistentEqlOptions(eqlOptions !== null && eqlOptions !== void 0 ? eqlOptions : {});
        setQuery();
        setFieldValue('eqlOptions', eqlOptions !== null && eqlOptions !== void 0 ? eqlOptions : {});
      });
    } else {
      setQuery();
    }
  }, [setFieldValue, setPersistentEqlQuery, setPersistentEqlOptions]);
  const {
    onOpenTimeline,
    loading: timelineQueryLoading
  } = (0, _use_rule_from_timeline.useRuleFromTimeline)(handleSetRuleFromTimeline);

  // if saved query failed to load:
  // - reset shouldLoadFormDynamically to false, as non existent query cannot be used for loading and execution
  const handleSavedQueryError = (0, _react.useCallback)(() => {
    if (!isQueryBarValid) {
      form.setFieldValue('shouldLoadQueryDynamically', false);
    }
  }, [isQueryBarValid, form]);
  const handleResetIndices = (0, _react.useCallback)(() => {
    const indexField = getFields().index;
    indexField.setValue(indicesConfig);
  }, [getFields, indicesConfig]);
  const handleOpenTimelineSearch = (0, _react.useCallback)(() => {
    setOpenTimelineSearch(true);
  }, []);
  const handleCloseTimelineSearch = (0, _react.useCallback)(() => {
    setOpenTimelineSearch(false);
  }, []);
  const {
    fields: esqlSuppressionFields,
    isLoading: isEsqlSuppressionLoading
  } = (0, _hooks.useAllEsqlRuleFields)({
    esqlQuery: (0, _utils.isEsqlRule)(ruleType) ? queryBar === null || queryBar === void 0 ? void 0 : (_queryBar$query = queryBar.query) === null || _queryBar$query === void 0 ? void 0 : _queryBar$query.query : undefined,
    indexPatternsFields: indexPattern.fields
  });

  /** Suppression fields being selected is a special case for our form logic, as we can't
   * disable these fields and leave users in a bad state that they cannot change.
   * The exception is threshold rules, which use an existing threshold field for the same
   * purpose and so are treated as if the field is always selected.  */
  const areSuppressionFieldsSelected = isThresholdRule || Boolean(alertSuppressionFields === null || alertSuppressionFields === void 0 ? void 0 : alertSuppressionFields.length);
  const {
    isSuppressionEnabled: isAlertSuppressionEnabled
  } = (0, _use_alert_suppression.useAlertSuppression)(ruleType);

  /** If we don't have ML field information, users can't meaningfully interact with suppression fields */
  const areSuppressionFieldsDisabledByMlFields = (0, _helpers.isMlRule)(ruleType) && (mlRuleConfigLoading || !mlSuppressionFields.length);

  /** Suppression fields are generally disabled if either:
   * - License is insufficient (i.e. less than platinum)
   * - ML Field information is not available
   */
  const areSuppressionFieldsDisabled = !isAlertSuppressionLicenseValid || areSuppressionFieldsDisabledByMlFields;
  const isSuppressionGroupByDisabled = (areSuppressionFieldsDisabled || isEsqlSuppressionLoading) && !areSuppressionFieldsSelected;
  const suppressionGroupByDisabledText = (0, _react.useMemo)(() => {
    if (areSuppressionFieldsDisabledByMlFields) {
      return i18n.MACHINE_LEARNING_SUPPRESSION_DISABLED_LABEL;
    } else {
      return alertSuppressionUpsellingMessage;
    }
  }, [alertSuppressionUpsellingMessage, areSuppressionFieldsDisabledByMlFields]);
  const suppressionGroupByFields = (0, _react.useMemo)(() => {
    if ((0, _utils.isEsqlRule)(ruleType)) {
      return esqlSuppressionFields;
    } else if ((0, _helpers.isMlRule)(ruleType)) {
      return mlSuppressionFields;
    } else {
      return termsAggregationFields;
    }
  }, [esqlSuppressionFields, mlSuppressionFields, ruleType, termsAggregationFields]);
  const alertSuppressionFieldsAppendText = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 348,
      columnNumber: 7
    }
  }, (0, _utils.isSuppressionRuleInGA)(ruleType) ? i18n.ALERT_SUPPRESSION_FIELDS_GA_LABEL_APPEND : i18n.ALERT_SUPPRESSION_FIELDS_TECH_PREVIEW_LABEL_APPEND), [ruleType]);
  const dataViewIndexPatternToggleButtonOptions = (0, _react.useMemo)(() => [{
    id: _types.DataSourceType.IndexPatterns,
    label: _i18n.i18n.translate('xpack.securitySolution.ruleDefine.indexTypeSelect.indexPattern', {
      defaultMessage: 'Index Patterns'
    }),
    iconType: dataSourceType === _types.DataSourceType.IndexPatterns ? 'checkInCircleFilled' : 'empty',
    'data-test-subj': `rule-index-toggle-${_types.DataSourceType.IndexPatterns}`
  }, {
    id: _types.DataSourceType.DataView,
    label: _i18n.i18n.translate('xpack.securitySolution.ruleDefine.indexTypeSelect.dataView', {
      defaultMessage: 'Data View'
    }),
    iconType: dataSourceType === _types.DataSourceType.DataView ? 'checkInCircleFilled' : 'empty',
    'data-test-subj': `rule-index-toggle-${_types.DataSourceType.DataView}`
  }], [dataSourceType]);
  const DataSource = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(RuleTypeEuiFormRow, {
      label: i18n.SOURCE,
      $isVisible: true,
      fullWidth: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 384,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "s",
      "data-test-subj": "dataViewIndexPatternButtonGroupFlexGroup",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 385,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 390,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 391,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.dataViewSelectorText1",
      defaultMessage: "Use Kibana ",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 392,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_doc_link.DocLink, {
      guidePath: "kibana",
      docPath: "data-views.html",
      linkText: "Data Views",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 396,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.dataViewSelectorText2",
      defaultMessage: " or specify individual ",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 397,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_doc_link.DocLink, {
      guidePath: "kibana",
      docPath: "index-patterns-api-create.html",
      linkText: "index patterns",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 401,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.dataViewSelectorText3",
      defaultMessage: " as your rule's data source to be searched.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 406,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 412,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(RuleTypeEuiFormRow, {
      $isVisible: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 413,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
      isFullWidth: true,
      legend: "Rule index pattern or data view selector",
      "data-test-subj": "dataViewIndexPatternButtonGroup",
      idSelected: dataSourceType,
      onChange: onChangeDataSource,
      options: dataViewIndexPatternToggleButtonOptions,
      color: "primary",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 414,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 426,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(StyledVisibleContainer, {
      isVisible: dataSourceType === _types.DataSourceType.DataView,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 427,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
      key: "DataViewSelector",
      path: "dataViewId",
      component: _data_view_selector_field.DataViewSelectorField,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 428,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(StyledVisibleContainer, {
      isVisible: dataSourceType === _types.DataSourceType.IndexPatterns,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 434,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(CommonUseField, {
      path: "index",
      config: {
        ..._schema.schema.index,
        labelAppend: indexModified ? /*#__PURE__*/_react.default.createElement(MyLabelButton, {
          onClick: handleResetIndices,
          iconType: "refresh",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 440,
            columnNumber: 21
          }
        }, i18n.RESET_DEFAULT_INDEX) : null
      },
      componentProps: {
        idAria: 'detectionEngineStepDefineRuleIndices',
        'data-test-subj': 'detectionEngineStepDefineRuleIndices',
        euiFieldProps: {
          fullWidth: true,
          placeholder: '',
          isDisabled: timelineQueryLoading,
          isLoading: timelineQueryLoading
        }
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 435,
        columnNumber: 15
      }
    })))));
  }, [timelineQueryLoading, dataSourceType, onChangeDataSource, dataViewIndexPatternToggleButtonOptions, indexModified, handleResetIndices]);
  const QueryBarMemo = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    key: "QueryBarDefineRule",
    path: "queryBar",
    config: {
      ..._schema.schema.queryBar,
      label: i18n.QUERY_BAR_LABEL,
      labelAppend: /*#__PURE__*/_react.default.createElement(MyLabelButton, {
        "data-test-subj": "importQueryFromSavedTimeline",
        onClick: handleOpenTimelineSearch,
        disabled: shouldLoadQueryDynamically,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 479,
          columnNumber: 13
        }
      }, i18n.IMPORT_TIMELINE_QUERY)
    },
    component: _query_bar_field.QueryBarField,
    componentProps: {
      idAria: 'detectionEngineStepDefineRuleQueryBar',
      indexPattern,
      isDisabled: isLoading || shouldLoadQueryDynamically || timelineQueryLoading,
      resetToSavedQuery: shouldLoadQueryDynamically,
      isLoading: isIndexPatternLoading || timelineQueryLoading,
      dataTestSubj: 'detectionEngineStepDefineRuleQueryBar',
      openTimelineSearch,
      onValidityChange: setIsQueryBarValid,
      onCloseTimelineSearch: handleCloseTimelineSearch,
      onSavedQueryError: handleSavedQueryError,
      defaultSavedQuery,
      onOpenTimeline,
      bubbleSubmitEvent: true
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 472,
      columnNumber: 7
    }
  }), [handleOpenTimelineSearch, shouldLoadQueryDynamically, indexPattern, isLoading, timelineQueryLoading, isIndexPatternLoading, openTimelineSearch, setIsQueryBarValid, handleCloseTimelineSearch, handleSavedQueryError, defaultSavedQuery, onOpenTimeline]);
  const selectRuleTypeProps = (0, _react.useMemo)(() => ({
    describedByIds: ['detectionEngineStepDefineRuleType'],
    isUpdateView,
    hasValidLicense: hasMlLicense,
    isMlAdmin: hasMlAdminPermissions
  }), [hasMlAdminPermissions, hasMlLicense, isUpdateView]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_step_content_wrapper.StepContentWrapper, {
    addPadding: !isUpdateView,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 536,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    form: form,
    "data-test-subj": "stepDefineRule",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 537,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "dataSourceType",
    component: _shared_imports.HiddenField,
    componentProps: {
      euiFieldProps: {
        fullWidth: true,
        placeholder: ''
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 538,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "ruleType",
    component: _select_rule_type.SelectRuleType,
    componentProps: selectRuleTypeProps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 548,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(RuleTypeEuiFormRow, {
    $isVisible: !(0, _helpers.isMlRule)(ruleType) && !(0, _utils.isEsqlRule)(ruleType),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 553,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 555,
      columnNumber: 15
    }
  }), DataSource)), /*#__PURE__*/_react.default.createElement(RuleTypeEuiFormRow, {
    $isVisible: !(0, _helpers.isMlRule)(ruleType),
    fullWidth: true,
    "data-test-subj": "defineRuleFormStepQueryEditor",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 559,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 565,
      columnNumber: 15
    }
  }), (0, _utils.isEqlRule)(ruleType) ? /*#__PURE__*/_react.default.createElement(_eql_query_edit.EqlQueryEdit, {
    path: "queryBar",
    eqlOptionsPath: "eqlOptions",
    fieldsToValidateOnChange: _alert_suppression_edit.ALERT_SUPPRESSION_FIELDS_FIELD_NAME,
    required: true,
    showFilterBar: true,
    dataView: indexPattern,
    loading: isIndexPatternLoading,
    disabled: isLoading,
    onValidityChange: setIsQueryBarValid,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 567,
      columnNumber: 17
    }
  }) : (0, _utils.isEsqlRule)(ruleType) ? /*#__PURE__*/_react.default.createElement(_esql_query_edit.EsqlQueryEdit, {
    path: "queryBar",
    fieldsToValidateOnChange: _alert_suppression_edit.ALERT_SUPPRESSION_FIELDS_FIELD_NAME,
    required: true,
    dataView: indexPattern,
    disabled: isLoading,
    loading: isLoading,
    onValidityChange: setIsQueryBarValid,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 579,
      columnNumber: 17
    }
  }) : QueryBarMemo)), !(0, _helpers.isMlRule)(ruleType) && !isQueryBarValid && (queryBar === null || queryBar === void 0 ? void 0 : (_queryBar$query2 = queryBar.query) === null || _queryBar$query2 === void 0 ? void 0 : _queryBar$query2.query) && /*#__PURE__*/_react.default.createElement(_ai_assistant.AiAssistant, {
    getFields: form.getFields,
    setFieldValue: form.setFieldValue,
    language: queryBar === null || queryBar === void 0 ? void 0 : (_queryBar$query3 = queryBar.query) === null || _queryBar$query3 === void 0 ? void 0 : _queryBar$query3.language,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 594,
      columnNumber: 13
    }
  }), (0, _utils.isQueryRule)(ruleType) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 602,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(RuleTypeEuiFormRow, {
    label: i18n.SAVED_QUERY_FORM_ROW_LABEL,
    $isVisible: Boolean(queryBarSavedId),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 603,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(CommonUseField, {
    path: "shouldLoadQueryDynamically",
    componentProps: {
      idAria: 'detectionEngineStepDefineRuleShouldLoadQueryDynamically',
      'data-test-subj': 'detectionEngineStepDefineRuleShouldLoadQueryDynamically',
      euiFieldProps: {
        disabled: isLoading,
        label: queryBarTitle ? i18n.getSavedQueryCheckboxLabel(queryBarTitle) : i18n.getSavedQueryCheckboxLabelWithoutName()
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 608,
      columnNumber: 17
    }
  }))), (0, _helpers.isMlRule)(ruleType) && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 625,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 627,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 628,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_machine_learning_job_id_edit.MachineLearningJobIdEdit, {
    path: "machineLearningJobId",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 629,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 631,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 632,
      columnNumber: 21
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 633,
      columnNumber: 21
    }
  }), /*#__PURE__*/_react.default.createElement(_create_ml_job_button.CreateCustomMlJobButton, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 634,
      columnNumber: 21
    }
  }))), /*#__PURE__*/_react.default.createElement(_anomaly_threshold_edit.AnomalyThresholdEdit, {
    path: "anomalyThreshold",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 637,
      columnNumber: 17
    }
  }))), isThresholdRule && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "thresholdInput",
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 642,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_threshold_edit.ThresholdEdit, {
    esFields: indexPattern.fields,
    path: "threshold",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 643,
      columnNumber: 15
    }
  })), (0, _utils.isThreatMatchRule)(ruleType) && /*#__PURE__*/_react.default.createElement(_threat_match_edit.ThreatMatchEdit, {
    indexPatternPath: "threatIndex",
    queryPath: "threatQueryBar",
    mappingPath: "threatMapping",
    indexPatterns: indexPattern,
    threatIndexPatterns: threatIndexPatterns,
    loading: threatIndexPatternsLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 647,
      columnNumber: 13
    }
  }), (0, _utils.isNewTermsRule)(ruleType) && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "newTermsInput",
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 657,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_new_terms_fields_edit.NewTermsFieldsEdit, {
    path: "newTermsFields",
    fieldNames: termsAggregationFieldNames,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 659,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_history_window_start_edit.HistoryWindowStartEdit, {
    path: "historyWindowSize",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 660,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 664,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(RuleTypeEuiFormRow, {
    $isVisible: isAlertSuppressionEnabled,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 666,
      columnNumber: 11
    }
  }, isThresholdRule ? /*#__PURE__*/_react.default.createElement(_threshold_alert_suppression_edit.ThresholdAlertSuppressionEdit, {
    suppressionFieldNames: threshold === null || threshold === void 0 ? void 0 : threshold.field,
    disabled: !isAlertSuppressionLicenseValid,
    disabledText: alertSuppressionUpsellingMessage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 668,
      columnNumber: 15
    }
  }) : /*#__PURE__*/_react.default.createElement(_alert_suppression_edit.AlertSuppressionEdit, {
    suppressibleFields: suppressionGroupByFields,
    labelAppend: alertSuppressionFieldsAppendText,
    warningText: isMlSuppressionIncomplete ? i18n.MACHINE_LEARNING_SUPPRESSION_INCOMPLETE_LABEL : undefined,
    disabled: isSuppressionGroupByDisabled,
    disabledText: suppressionGroupByDisabledText,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 674,
      columnNumber: 15
    }
  })), !(0, _helpers.isMlRule)(ruleType) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_required_fields.RequiredFields, {
    path: "requiredFields",
    indexPatternFields: indexPattern.fields,
    isIndexPatternLoading: isIndexPatternLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 689,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 694,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_related_integrations.RelatedIntegrations, {
    path: "relatedIntegrations",
    dataTestSubj: "relatedIntegrations",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 697,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "timeline",
    component: _pick_timeline.PickTimeline,
    componentProps: {
      idAria: 'detectionEngineStepDefineRuleTimeline',
      isDisabled: isLoading || !canAttachTimelineTemplates,
      dataTestSubj: 'detectionEngineStepDefineRuleTimeline'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 698,
      columnNumber: 11
    }
  }))));
};
const StepDefineRule = exports.StepDefineRule = /*#__PURE__*/(0, _react.memo)(StepDefineRuleComponent);
const StepDefineRuleReadOnlyComponent = ({
  addPadding,
  defaultValues: data,
  descriptionColumns,
  indexPattern
}) => {
  const dataForDescription = (0, _helpers2.getStepDataDataSource)(data);
  const transformFields = (0, _use_experimental_feature_fields_transform.useExperimentalFeatureFieldsTransform)();
  const fieldsToDisplay = transformFields(dataForDescription);
  return /*#__PURE__*/_react.default.createElement(_step_content_wrapper.StepContentWrapper, {
    "data-test-subj": "definitionRule",
    addPadding: addPadding,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 725,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_description_step.StepRuleDescription, {
    columns: descriptionColumns,
    schema: (0, _helpers2.filterRuleFieldsForType)(_schema.schema, data.ruleType),
    data: (0, _helpers2.filterRuleFieldsForType)(fieldsToDisplay, data.ruleType),
    indexPatterns: indexPattern,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 726,
      columnNumber: 7
    }
  }));
};
const StepDefineRuleReadOnly = exports.StepDefineRuleReadOnly = /*#__PURE__*/(0, _react.memo)(StepDefineRuleReadOnlyComponent);