"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePreviewInvocationCount = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _helpers = require("../../pages/rule_creation/helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const usePreviewInvocationCount = ({
  timeframeOptions
}) => {
  const timeframeDuration = (timeframeOptions.timeframeEnd.valueOf() / 1000 - timeframeOptions.timeframeStart.valueOf() / 1000) * 1000;
  const {
    unit: intervalUnit,
    value: intervalValue
  } = (0, _helpers.getTimeTypeValue)(timeframeOptions.interval);
  const duration = _moment.default.duration(intervalValue, intervalUnit);
  const ruleIntervalDuration = duration.asMilliseconds();
  const invocationCount = Math.max(Math.ceil(timeframeDuration / ruleIntervalDuration), 1);
  const interval = timeframeOptions.interval;
  const {
    unit: lookbackUnit,
    value: lookbackValue
  } = (0, _helpers.getTimeTypeValue)(timeframeOptions.lookback);
  duration.add(lookbackValue, lookbackUnit);
  const from = `now-${duration.asSeconds()}s`;
  return {
    invocationCount,
    interval,
    from
  };
};
exports.usePreviewInvocationCount = usePreviewInvocationCount;