"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildThrottleDescription = void 0;
var _fp = require("lodash/fp");
var _throttle_select_field = require("../throttle_select_field");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buildThrottleDescription = (value = _throttle_select_field.DEFAULT_THROTTLE_OPTION.value, title) => {
  const throttleOption = (0, _fp.find)(['value', value], _throttle_select_field.THROTTLE_OPTIONS_FOR_RULE_CREATION_AND_EDITING);
  return {
    title,
    description: throttleOption ? throttleOption.text : value
  };
};
exports.buildThrottleDescription = buildThrottleDescription;