"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DETECTION_RULES_CREATE_FORM_CONVERSATION_ID = exports.ASK_ASSISTANT_USER_PROMPT = exports.ASK_ASSISTANT_TOOLTIP = exports.ASK_ASSISTANT_ERROR_BUTTON = exports.ASK_ASSISTANT_DESCRIPTION = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ASK_ASSISTANT_ERROR_BUTTON = exports.ASK_ASSISTANT_ERROR_BUTTON = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.askAssistant', {
  defaultMessage: 'Ask Assistant'
});
const ASK_ASSISTANT_DESCRIPTION = exports.ASK_ASSISTANT_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.askAssistantDesc', {
  defaultMessage: 'Rule query error'
});
const ASK_ASSISTANT_USER_PROMPT = language => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.askAssistantUserPrompt', {
  defaultMessage: 'Explain all the errors present in the {language} query above. Generate a new working query, making sure all the errors are resolved in your response.',
  values: {
    language
  }
});
exports.ASK_ASSISTANT_USER_PROMPT = ASK_ASSISTANT_USER_PROMPT;
const ASK_ASSISTANT_TOOLTIP = exports.ASK_ASSISTANT_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.askAssistantToolTip', {
  defaultMessage: 'Fix query or generate new one'
});
const DETECTION_RULES_CREATE_FORM_CONVERSATION_ID = exports.DETECTION_RULES_CREATE_FORM_CONVERSATION_ID = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleManagement.detectionRulesCreateEditFormConversationId', {
  defaultMessage: 'Detection Rules Create form'
});