"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.esqlQueryValidatorFactory = esqlQueryValidatorFactory;
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
var _esql_query_columns = require("../../../logic/esql_query_columns");
var _error_codes = require("./error_codes");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function esqlQueryValidatorFactory({
  queryClient
}) {
  return async (...args) => {
    const [{
      value
    }] = args;
    const esqlQuery = value.query.query;
    if (esqlQuery.trim() === '') {
      return;
    }
    try {
      const {
        isEsqlQueryAggregating,
        hasMetadataOperator,
        errors
      } = (0, _securitysolutionUtils.parseEsqlQuery)(esqlQuery);

      // Check if there are any syntax errors
      if (errors.length) {
        return constructSyntaxError(new Error(errors[0].message));
      }

      // non-aggregating query which does not have metadata, is not a valid one
      if (!isEsqlQueryAggregating && !hasMetadataOperator) {
        return {
          code: _error_codes.ESQL_ERROR_CODES.ERR_MISSING_ID_FIELD_FROM_RESULT,
          message: i18n.ESQL_VALIDATION_MISSING_METADATA_OPERATOR_IN_QUERY_ERROR
        };
      }
      const columns = await (0, _esql_query_columns.fetchEsqlQueryColumns)({
        esqlQuery,
        queryClient
      });

      // for non-aggregating query, we want to disable queries w/o _id property returned in response
      if (!isEsqlQueryAggregating && !hasIdColumn(columns)) {
        return {
          code: _error_codes.ESQL_ERROR_CODES.ERR_MISSING_ID_FIELD_FROM_RESULT,
          message: i18n.ESQL_VALIDATION_MISSING_ID_FIELD_IN_QUERY_ERROR
        };
      }
    } catch (error) {
      return constructValidationError(error);
    }
  };
}
function hasIdColumn(columns) {
  return columns.some(({
    id
  }) => '_id' === id);
}
function constructSyntaxError(error) {
  return {
    code: _error_codes.ESQL_ERROR_CODES.INVALID_SYNTAX,
    message: error !== null && error !== void 0 && error.message ? i18n.esqlValidationErrorMessage(error.message) : i18n.ESQL_VALIDATION_UNKNOWN_ERROR,
    error
  };
}
function constructValidationError(error) {
  return {
    code: _error_codes.ESQL_ERROR_CODES.INVALID_ESQL,
    message: error !== null && error !== void 0 && error.message ? i18n.esqlValidationErrorMessage(error.message) : i18n.ESQL_VALIDATION_UNKNOWN_ERROR,
    error
  };
}