"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSyncSourcererUrlState = exports.useRestoreDataViewManagerStateFromURL = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _model = require("../../sourcerer/store/model");
var _global_query_string = require("../../common/utils/global_query_string");
var _constants = require("../../common/hooks/constants");
var _selectors = require("../../common/store/selectors");
var _actions = require("../../common/store/actions");
var _use_experimental_features = require("../../common/hooks/use_experimental_features");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO: remove this in cleanup phase Remove deprecated sourcerer code https://github.com/elastic/security-team/issues/12665
const useSyncSourcererUrlState = (scopeId = _model.SourcererScopeName.default) => {
  const scopeDataViewId = (0, _reactRedux.useSelector)(state => {
    return _selectors.sourcererSelectors.sourcererScopeSelectedDataViewId(state, scopeId);
  });
  const selectedPatterns = (0, _reactRedux.useSelector)(state => {
    return _selectors.sourcererSelectors.sourcererScopeSelectedPatterns(state, scopeId);
  });
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const dispatch = (0, _reactRedux.useDispatch)();
  const updateUrlParam = (0, _global_query_string.useUpdateUrlParam)(_constants.URL_PARAM_KEY.sourcerer);
  const onInitializeUrlParam = (0, _react.useCallback)(initialState => {
    // TODO: This is due to a new feature https://github.com/elastic/security-team/issues/11959
    // if new picker flag is enabled, we should not kick off the legacy url flow
    if (newDataViewPickerEnabled) {
      return;
    }

    // Initialize the store with value from UrlParam.
    if (initialState != null) {
      Object.keys(initialState).forEach(scope => {
        if (!(scope === _model.SourcererScopeName.default && scopeId === _model.SourcererScopeName.detections)) {
          var _initialState$scope$i, _initialState$scope, _initialState$scope$s, _initialState$scope2;
          dispatch(_actions.sourcererActions.setSelectedDataView({
            id: scope,
            selectedDataViewId: (_initialState$scope$i = (_initialState$scope = initialState[scope]) === null || _initialState$scope === void 0 ? void 0 : _initialState$scope.id) !== null && _initialState$scope$i !== void 0 ? _initialState$scope$i : null,
            selectedPatterns: (_initialState$scope$s = (_initialState$scope2 = initialState[scope]) === null || _initialState$scope2 === void 0 ? void 0 : _initialState$scope2.selectedPatterns) !== null && _initialState$scope$s !== void 0 ? _initialState$scope$s : []
          }));
        }
      });
    } else {
      // Initialize the UrlParam with values from the store.
      // It isn't strictly necessary but I am keeping it for compatibility with the previous implementation.
      if (scopeDataViewId) {
        updateUrlParam({
          [_model.SourcererScopeName.default]: {
            id: scopeDataViewId,
            selectedPatterns
          }
        });
      }
    }
  }, [dispatch, newDataViewPickerEnabled, scopeDataViewId, scopeId, selectedPatterns, updateUrlParam]);
  (0, _global_query_string.useInitializeUrlParam)(_constants.URL_PARAM_KEY.sourcerer, onInitializeUrlParam);
};

/**
 * Restores data view selection automatically if (and only if) the sourcerer url param is set during app init. (only during the initial render)
 * See `useInitializeUrlParam` for details.
 * The param itself is updated in the picker component, after user changes the selection manually.
 */
exports.useSyncSourcererUrlState = useSyncSourcererUrlState;
const useRestoreDataViewManagerStateFromURL = (initDataViewPickerWithSelection, scopeId = _model.SourcererScopeName.default) => {
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const onInitializeUrlParam = (0, _react.useCallback)(initialState => {
    // TODO: This is due to a new feature https://github.com/elastic/security-team/issues/11959
    // dont do anything if new picker is not enabled
    if (!newDataViewPickerEnabled) {
      return;
    }
    if (initialState === null) {
      return initDataViewPickerWithSelection([]);
    }

    // Select data view for specific scope, based on the UrlParam.
    const urlBasedSelection = Object.keys(initialState).map(scope => {
      var _initialState$scope3, _initialState$scope4;
      // NOTE: looks like this is about skipping the init when the active page is detections
      // We should investigate this.
      if (scope === _model.SourcererScopeName.default && scopeId === _model.SourcererScopeName.detections) {
        return undefined;
      }
      return {
        scope,
        id: (_initialState$scope3 = initialState[scope]) === null || _initialState$scope3 === void 0 ? void 0 : _initialState$scope3.id,
        fallbackPatterns: (_initialState$scope4 = initialState[scope]) === null || _initialState$scope4 === void 0 ? void 0 : _initialState$scope4.selectedPatterns
      };
    }).filter(Boolean);
    initDataViewPickerWithSelection(urlBasedSelection);
  }, [initDataViewPickerWithSelection, newDataViewPickerEnabled, scopeId]);
  (0, _global_query_string.useInitializeUrlParam)(_constants.URL_PARAM_KEY.sourcerer, onInitializeUrlParam);
};
exports.useRestoreDataViewManagerStateFromURL = useRestoreDataViewManagerStateFromURL;