"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCreateSecurityDashboardLink = void 0;
var _react = require("react");
var _dashboard_context = require("../context/dashboard_context");
var _link_to = require("../../common/components/link_to");
var _common = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCreateSecurityDashboardLink = () => {
  const getSecuritySolutionUrl = (0, _link_to.useGetSecuritySolutionUrl)();
  const securityTags = (0, _dashboard_context.useSecurityTags)();
  const url = getSecuritySolutionUrl({
    deepLinkId: _common.SecurityPageName.dashboards,
    path: 'create'
  });
  const result = (0, _react.useMemo)(() => {
    var _securityTags$;
    const firstSecurityTagId = securityTags === null || securityTags === void 0 ? void 0 : (_securityTags$ = securityTags[0]) === null || _securityTags$ === void 0 ? void 0 : _securityTags$.id;
    if (!firstSecurityTagId) {
      return {
        isLoading: true,
        url
      };
    }
    return {
      isLoading: false,
      url
    };
  }, [securityTags, url]);
  return result;
};
exports.useCreateSecurityDashboardLink = useCreateSecurityDashboardLink;