"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTimelineClick = void 0;
var _react = require("react");
var _helpers = require("../../../timelines/components/open_timeline/helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useTimelineClick = () => {
  const queryTimelineById = (0, _helpers.useQueryTimelineById)();
  const handleTimelineClick = (0, _react.useCallback)((timelineId, onError) => {
    queryTimelineById({
      timelineId,
      onError
    });
  }, [queryTimelineById]);
  return handleTimelineClick;
};
exports.useTimelineClick = useTimelineClick;