"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.alertsTelemetryEvents = exports.alertsGroupingToggledEvent = exports.alertsGroupingTakeActionEvent = exports.alertsGroupingChangedEvent = void 0;
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const alertsGroupingToggledEvent = exports.alertsGroupingToggledEvent = {
  eventType: _types.AlertsEventTypes.AlertsGroupingToggled,
  schema: {
    isOpen: {
      type: 'boolean',
      _meta: {
        description: 'on or off',
        optional: false
      }
    },
    tableId: {
      type: 'keyword',
      _meta: {
        description: 'Table ID',
        optional: false
      }
    },
    groupNumber: {
      type: 'integer',
      _meta: {
        description: 'Group number',
        optional: false
      }
    }
  }
};
const alertsGroupingChangedEvent = exports.alertsGroupingChangedEvent = {
  eventType: _types.AlertsEventTypes.AlertsGroupingChanged,
  schema: {
    tableId: {
      type: 'keyword',
      _meta: {
        description: 'Table ID',
        optional: false
      }
    },
    groupByField: {
      type: 'keyword',
      _meta: {
        description: 'Selected field',
        optional: false
      }
    }
  }
};
const alertsGroupingTakeActionEvent = exports.alertsGroupingTakeActionEvent = {
  eventType: _types.AlertsEventTypes.AlertsGroupingTakeAction,
  schema: {
    tableId: {
      type: 'keyword',
      _meta: {
        description: 'Table ID',
        optional: false
      }
    },
    groupNumber: {
      type: 'integer',
      _meta: {
        description: 'Group number',
        optional: false
      }
    },
    status: {
      type: 'keyword',
      _meta: {
        description: 'Alert status',
        optional: false
      }
    },
    groupByField: {
      type: 'keyword',
      _meta: {
        description: 'Selected field',
        optional: false
      }
    }
  }
};
const alertsTelemetryEvents = exports.alertsTelemetryEvents = [alertsGroupingToggledEvent, alertsGroupingChangedEvent, alertsGroupingTakeActionEvent];