"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.suspendProcess = exports.killProcess = void 0;
var _kibana = require("../kibana");
var _constants = require("../../../../common/endpoint/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** Kills a process specified by pid or entity id on a host running Endpoint Security */
const killProcess = params => {
  return _kibana.KibanaServices.get().http.post(_constants.KILL_PROCESS_ROUTE, {
    body: JSON.stringify(params),
    version: '2023-10-31'
  });
};

/** Suspends a process specified by pid or entity id on a host running Endpoint Security */
exports.killProcess = killProcess;
const suspendProcess = params => {
  return _kibana.KibanaServices.get().http.post(_constants.SUSPEND_PROCESS_ROUTE, {
    body: JSON.stringify(params),
    version: '2023-10-31'
  });
};
exports.suspendProcess = suspendProcess;