"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertDetailsFieldValue = void 0;
var _fp = require("lodash/fp");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Gets the array of values for a given field in an Alert Details data
 *
 * @param category
 * @param field
 * @param data
 */
const getEventDetailsFieldValues = ({
  category,
  field
}, data) => {
  var _ref, _find$values, _find, _find2;
  const categoryCompat = category === 'signal' ? 'kibana' : category === 'kibana' ? 'signal' : category;
  const fieldCompat = category === 'signal' ? field.replace('signal', 'kibana.alert').replace('rule.id', 'rule.uuid') : category === 'kibana' ? field.replace('kibana.alert', 'signal').replace('rule.uuid', 'rule.id') : field;
  return (_ref = (_find$values = (_find = (0, _fp.find)({
    category,
    field
  }, data)) === null || _find === void 0 ? void 0 : _find.values) !== null && _find$values !== void 0 ? _find$values : (_find2 = (0, _fp.find)({
    category: categoryCompat,
    field: fieldCompat
  }, data)) === null || _find2 === void 0 ? void 0 : _find2.values) !== null && _ref !== void 0 ? _ref : [];
};

/**
 * Gets a single value for a given Alert Details data field. If the field has multiple values,
 * the first one will be returned.
 *
 * @param category
 * @param field
 * @param data
 */
const getAlertDetailsFieldValue = ({
  category,
  field
}, data) => {
  const currentField = getEventDetailsFieldValues({
    category,
    field
  }, data);
  return currentField && currentField.length > 0 ? currentField[0] : '';
};
exports.getAlertDetailsFieldValue = getAlertDetailsFieldValue;