"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTrackHttpRequest = void 0;
var _react = require("react");
var _use_start_transaction = require("./use_start_transaction");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useTrackHttpRequest = () => {
  const {
    startTransaction
  } = (0, _use_start_transaction.useStartTransaction)();
  const startTracking = (0, _react.useCallback)(({
    name,
    spanName = 'fetch'
  }) => {
    // Create the transaction, the managed flag is turned off to prevent it from being polluted by non-related automatic spans.
    // The managed flag can be turned on to investigate high latency requests in APM.
    // However, note that by enabling the managed flag, the transaction trace may be distorted by other requests information.
    const transaction = startTransaction({
      name,
      type: 'http-request',
      options: {
        managed: false
      }
    });
    // Create a blocking span to control the transaction time and prevent it from closing automatically with partial batch responses.
    // The blocking span needs to be ended manually when the request finishes.
    const span = transaction === null || transaction === void 0 ? void 0 : transaction.startSpan(spanName, 'http-request', {
      blocking: true
    });
    return {
      endTracking: result => {
        transaction === null || transaction === void 0 ? void 0 : transaction.addLabels({
          result
        });
        span === null || span === void 0 ? void 0 : span.end();
      }
    };
  }, [startTransaction]);
  return {
    startTracking
  };
};
exports.useTrackHttpRequest = useTrackHttpRequest;