"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInvalidFilterQuery = exports.genHash = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _store = require("../store");
var _app = require("../store/app");
var _use_app_toasts = require("./use_app_toasts");
var _use_selector = require("./use_selector");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const genHash = message => message.split('')
// eslint-disable-next-line no-bitwise
.reduce((a, b) => (a << 5) - a + b.charCodeAt(0) | 0, 0).toString();
exports.genHash = genHash;
/**
 * Adds a toast error message whenever invalid KQL is submitted through the search bar
 */
const useInvalidFilterQuery = ({
  id,
  filterQuery,
  kqlError,
  // TODO: Review and remove these (query, startDate, endDate) props.
  // Change of any of these props will not trigger new error toast.
  query,
  startDate,
  endDate
}) => {
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const getErrorsSelector = (0, _react.useMemo)(() => _store.appSelectors.errorsSelector(), []);
  const errors = (0, _use_selector.useDeepEqualSelector)(getErrorsSelector);
  const name = kqlError === null || kqlError === void 0 ? void 0 : kqlError.name;
  const message = kqlError === null || kqlError === void 0 ? void 0 : kqlError.message;
  (0, _react.useEffect)(() => {
    if (!filterQuery && message && name) {
      dispatch(_app.appActions.addErrorHash({
        id,
        hash: genHash(message),
        title: name,
        message: [message]
      }));
    }
  }, [id, filterQuery, addError, query, startDate, endDate, dispatch, message, name]);
  (0, _react.useEffect)(() => {
    const myError = errors.find(e => e.id === id);
    if (myError != null && myError.displayError && kqlError != null) {
      // Removes error stack from user view
      delete kqlError.stack; // Mutates the error object and can possibly lead to side effects, only going this route for type issues. Change when we add a stackless toast error
      addError(kqlError, {
        title: kqlError.name
      });
    }
  }, [addError, errors, id, kqlError]);
};
exports.useInvalidFilterQuery = useInvalidFilterQuery;