"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDefaultAIConnectorId = void 0;
var _helpers = require("@kbn/elastic-assistant/impl/assistant/helpers");
var _react = require("react");
var _constants = require("../../../common/constants");
var _use_ai_connectors = require("./use_ai_connectors");
var _kibana = require("../lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDefaultAIConnectorId = () => {
  var _getDefaultConnector;
  const {
    settings,
    uiSettings,
    featureFlags
  } = (0, _kibana.useKibana)().services;
  const {
    aiConnectors: connectors,
    isLoading: isLoadingConnectors
  } = (0, _use_ai_connectors.useAIConnectors)();
  const legacyDefaultConnectorId = uiSettings.get(_constants.DEFAULT_AI_CONNECTOR);
  const useNewDefaultConnector = featureFlags.getBooleanValue(_constants.AI_ASSISTANT_DEFAULT_LLM_SETTING_ENABLED, _constants.AI_ASSISTANT_DEFAULT_LLM_SETTING_ENABLED_VALUE);
  const newDefaultConnectorId = (_getDefaultConnector = (0, _helpers.getDefaultConnector)(connectors, settings)) === null || _getDefaultConnector === void 0 ? void 0 : _getDefaultConnector.id;
  return (0, _react.useMemo)(() => ({
    defaultConnectorId: useNewDefaultConnector ? newDefaultConnectorId : legacyDefaultConnectorId,
    isLoading: isLoadingConnectors
  }), [useNewDefaultConnector, newDefaultConnectorId, legacyDefaultConnectorId, isLoadingConnectors]);
};
exports.useDefaultAIConnectorId = useDefaultAIConnectorId;