"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSyncSearchBarUrlParams = void 0;
var _reactRedux = require("react-redux");
var _react = require("react");
var _fp = require("lodash/fp");
var _store = require("../../store");
var _global_query_string = require("../../utils/global_query_string");
var _use_url_state = require("../use_url_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSyncSearchBarUrlParams = () => {
  const updateSavedQueryUrlParam = (0, _global_query_string.useUpdateUrlParam)(_use_url_state.URL_PARAM_KEY.savedQuery);
  const updateAppQueryUrlParam = (0, _global_query_string.useUpdateUrlParam)(_use_url_state.URL_PARAM_KEY.appQuery);
  const updateFilterUrlParam = (0, _global_query_string.useUpdateUrlParam)(_use_url_state.URL_PARAM_KEY.filters);
  const getGlobalQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalQuerySelector(), []);
  const getGlobalFiltersQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalFiltersQuerySelector(), []);
  const getGlobalSavedQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalSavedQuerySelector(), []);
  const query = (0, _reactRedux.useSelector)(getGlobalQuerySelector);
  const filters = (0, _reactRedux.useSelector)(getGlobalFiltersQuerySelector);
  const savedQuery = (0, _reactRedux.useSelector)(getGlobalSavedQuerySelector);
  (0, _react.useEffect)(() => {
    if (savedQuery != null && savedQuery.id !== '') {
      var _savedQuery$id;
      updateSavedQueryUrlParam((_savedQuery$id = savedQuery === null || savedQuery === void 0 ? void 0 : savedQuery.id) !== null && _savedQuery$id !== void 0 ? _savedQuery$id : null);
      updateAppQueryUrlParam(null);
      updateFilterUrlParam(null);
    } else {
      updateSavedQueryUrlParam(null);
      updateAppQueryUrlParam((0, _fp.isEmpty)(query.query) ? null : query);
      updateFilterUrlParam((0, _fp.isEmpty)(filters) ? null : filters);
    }
  }, [savedQuery, query, filters, updateSavedQueryUrlParam, updateAppQueryUrlParam, updateFilterUrlParam]);
};
exports.useSyncSearchBarUrlParams = useSyncSearchBarUrlParams;