"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInitSearchBarFromUrlParams = void 0;
var _reactRedux = require("react-redux");
var _react = require("react");
var _constants = require("../../store/inputs/constants");
var _kibana = require("../../lib/kibana");
var _store = require("../../store");
var _inputs = require("../../store/inputs");
var _global_query_string = require("../../utils/global_query_string");
var _use_url_state = require("../use_url_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useInitSearchBarFromUrlParams = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    filterManager,
    savedQueries
  } = (0, _kibana.useKibana)().services.data.query;
  const getGlobalFiltersQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalFiltersQuerySelector(), []);
  const filtersFromStore = (0, _reactRedux.useSelector)(getGlobalFiltersQuerySelector);
  const onInitializeAppQueryFromUrlParam = (0, _react.useCallback)(initialState => {
    if (initialState != null) {
      dispatch(_inputs.inputsActions.setFilterQuery({
        id: _constants.InputsModelId.global,
        query: initialState.query,
        language: initialState.language
      }));
    }
  }, [dispatch]);
  const onInitializeFiltersFromUrlParam = (0, _react.useCallback)(initialState => {
    if (initialState != null) {
      filterManager.setFilters(initialState);
      dispatch(_inputs.inputsActions.setSearchBarFilter({
        id: _constants.InputsModelId.global,
        filters: initialState
      }));
    } else {
      // Clear app filters and preserve pinned filters. It ensures that other App filters don't leak into security solution.
      filterManager.setAppFilters(filtersFromStore);
      dispatch(_inputs.inputsActions.setSearchBarFilter({
        id: _constants.InputsModelId.global,
        filters: filterManager.getFilters()
      }));
    }
  }, [filterManager, dispatch, filtersFromStore]);
  const onInitializeSavedQueryFromUrlParam = (0, _react.useCallback)(savedQueryId => {
    if (savedQueryId != null && savedQueryId !== '') {
      savedQueries.getSavedQuery(savedQueryId).then(savedQueryData => {
        const filters = savedQueryData.attributes.filters || [];
        const query = savedQueryData.attributes.query;
        filterManager.setFilters(filters);
        dispatch(_inputs.inputsActions.setSearchBarFilter({
          id: _constants.InputsModelId.global,
          filters
        }));
        dispatch(_inputs.inputsActions.setFilterQuery({
          id: _constants.InputsModelId.global,
          ...query
        }));
        dispatch(_inputs.inputsActions.setSavedQuery({
          id: _constants.InputsModelId.global,
          savedQuery: savedQueryData
        }));
      });
    }
  }, [dispatch, filterManager, savedQueries]);
  (0, _global_query_string.useInitializeUrlParam)(_use_url_state.URL_PARAM_KEY.appQuery, onInitializeAppQueryFromUrlParam);
  (0, _global_query_string.useInitializeUrlParam)(_use_url_state.URL_PARAM_KEY.filters, onInitializeFiltersFromUrlParam);
  (0, _global_query_string.useInitializeUrlParam)(_use_url_state.URL_PARAM_KEY.savedQuery, onInitializeSavedQueryFromUrlParam);
};
exports.useInitSearchBarFromUrlParams = useInitSearchBarFromUrlParams;