"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIsInSecurityApp = exports.isInSecurityApp = void 0;
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _react = require("react");
var _common = require("../../../common");
var _kibana = require("../lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isInSecurityApp = currentAppId => {
  return !!currentAppId && currentAppId === _common.APP_UI_ID;
};
exports.isInSecurityApp = isInSecurityApp;
const useIsInSecurityApp = () => {
  const {
    services: {
      application
    }
  } = (0, _kibana.useKibana)();
  const currentAppId = (0, _useObservable.default)(application.currentAppId$);
  return (0, _react.useMemo)(() => isInSecurityApp(currentAppId), [currentAppId]);
};
exports.useIsInSecurityApp = useIsInSecurityApp;