"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAlertResponseActionsSupport = exports.ALERT_EVENT_DATA_MISSING_AGENT_ID_FIELD = void 0;
var _react = require("react");
var _fp = require("lodash/fp");
var _i18n = require("@kbn/i18n");
var _get_event_details_agent_id_field = require("../../lib/endpoint/utils/get_event_details_agent_id_field");
var _get_host_platform = require("../../lib/endpoint/utils/get_host_platform");
var _get_event_details_field_values = require("../../lib/endpoint/utils/get_event_details_field_values");
var _endpoint = require("../../lib/endpoint");
var _constants = require("../../../../common/endpoint/service/response_actions/constants");
var _translations = require("../../translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALERT_EVENT_DATA_MISSING_AGENT_ID_FIELD = (agentTypeName, missingField) => {
  return _i18n.i18n.translate('xpack.securitySolution.useAlertResponseActionsSupport.missingAgentIdField', {
    defaultMessage: 'Alert event data missing {agentTypeName} agent identifier field ({missingField})',
    values: {
      missingField,
      agentTypeName
    }
  });
};
exports.ALERT_EVENT_DATA_MISSING_AGENT_ID_FIELD = ALERT_EVENT_DATA_MISSING_AGENT_ID_FIELD;
/**
 * Determines the level of support that an alert's host has for Response Actions.
 * This hook already checks feature flags to determine the level of support that we have available
 */
const useAlertResponseActionsSupport = (eventData = []) => {
  const isAlert = (0, _react.useMemo)(() => {
    return (0, _fp.some)({
      category: 'kibana',
      field: 'kibana.alert.rule.uuid'
    }, eventData);
  }, [eventData]);
  const agentType = (0, _react.useMemo)(() => {
    var _find$values, _find, _find$values2, _find2;
    if (((_find$values = (_find = (0, _fp.find)({
      field: 'agent.type'
    }, eventData)) === null || _find === void 0 ? void 0 : _find.values) !== null && _find$values !== void 0 ? _find$values : []).includes('endpoint')) {
      return 'endpoint';
    }
    const eventModuleValues = (_find$values2 = (_find2 = (0, _fp.find)({
      field: 'event.module'
    }, eventData)) === null || _find2 === void 0 ? void 0 : _find2.values) !== null && _find$values2 !== void 0 ? _find$values2 : [];
    if (eventModuleValues.includes('sentinel_one')) {
      return 'sentinel_one';
    }
    if (eventModuleValues.includes('crowdstrike')) {
      return 'crowdstrike';
    }
    if (eventModuleValues.includes('microsoft_defender_endpoint') || eventModuleValues.includes('m365_defender') || eventModuleValues.includes('o365')) {
      return 'microsoft_defender_endpoint';
    }
    return undefined;
  }, [eventData]);
  const isFeatureEnabled = (0, _react.useMemo)(() => {
    return agentType ? (0, _endpoint.isAgentTypeAndActionSupported)(agentType) : false;
  }, [agentType]);
  const {
    agentIdField,
    agentId
  } = (0, _react.useMemo)(() => {
    let field = '';
    let id = '';
    if (agentType) {
      const eventAgentIdInfo = (0, _get_event_details_agent_id_field.getEventDetailsAgentIdField)(agentType, eventData);
      field = eventAgentIdInfo.field;
      id = eventAgentIdInfo.agentId;
    }
    return {
      agentId: id,
      agentIdField: field
    };
  }, [agentType, eventData]);
  const doesHostSupportResponseActions = (0, _react.useMemo)(() => {
    return Boolean(isFeatureEnabled && agentId && agentType);
  }, [agentId, agentType, isFeatureEnabled]);
  const supportedActions = (0, _react.useMemo)(() => {
    return _constants.RESPONSE_ACTION_API_COMMANDS_NAMES.reduce((acc, responseActionName) => {
      acc[responseActionName] = false;
      if (agentType && isFeatureEnabled) {
        acc[responseActionName] = (0, _endpoint.isAgentTypeAndActionSupported)(agentType, responseActionName, 'manual');
      }
      return acc;
    }, {});
  }, [agentType, isFeatureEnabled]);
  const hostName = (0, _react.useMemo)(() => {
    return (0, _get_event_details_field_values.getAlertDetailsFieldValue)({
      category: 'host',
      field: 'host.name'
    }, eventData);
  }, [eventData]);
  const platform = (0, _react.useMemo)(() => {
    return (0, _get_host_platform.getHostPlatform)(eventData !== null && eventData !== void 0 ? eventData : []);
  }, [eventData]);
  const unsupportedReason = (0, _react.useMemo)(() => {
    if (!doesHostSupportResponseActions) {
      if (!agentType) {
        // No message is provided for this condition because the
        // return from this hook will always default to `endpoint`
        return;
      }
      if (!agentId) {
        return ALERT_EVENT_DATA_MISSING_AGENT_ID_FIELD((0, _translations.getAgentTypeName)(agentType), agentIdField);
      }
    }
  }, [agentId, agentIdField, agentType, doesHostSupportResponseActions]);
  return (0, _react.useMemo)(() => {
    return {
      isSupported: doesHostSupportResponseActions,
      unsupportedReason,
      isAlert,
      details: {
        agentType: agentType || 'endpoint',
        agentId,
        hostName,
        platform,
        agentIdField,
        agentSupport: supportedActions
      }
    };
  }, [agentId, agentIdField, agentType, doesHostSupportResponseActions, hostName, isAlert, platform, supportedActions, unsupportedReason]);
};
exports.useAlertResponseActionsSupport = useAlertResponseActionsSupport;