"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTimelineLastEventTime = void 0;
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _fp = require("lodash/fp");
var _react = require("react");
var _rxjs = require("rxjs");
var _common = require("@kbn/data-plugin/common");
var _kibana = require("../../../lib/kibana");
var _timeline = require("../../../../../common/search_strategy/timeline");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_app_toasts = require("../../../hooks/use_app_toasts");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useTimelineLastEventTime = ({
  indexKey,
  indexNames,
  details
}) => {
  const {
    data
  } = (0, _kibana.useKibana)().services;
  const refetch = (0, _react.useRef)(_fp.noop);
  const abortCtrl = (0, _react.useRef)(new AbortController());
  const searchSubscription$ = (0, _react.useRef)(new _rxjs.Subscription());
  const [loading, setLoading] = (0, _react.useState)(false);
  const [TimelineLastEventTimeRequest, setTimelineLastEventTimeRequest] = (0, _react.useState)({
    defaultIndex: indexNames,
    factoryQueryType: _timeline.TimelineEventsQueries.lastEventTime,
    indexKey,
    details
  });
  const [timelineLastEventTimeResponse, setTimelineLastEventTimeResponse] = (0, _react.useState)({
    lastSeen: null,
    refetch: refetch.current,
    errorMessage: undefined
  });
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const timelineLastEventTimeSearch = (0, _react.useCallback)(request => {
    const asyncSearch = async () => {
      abortCtrl.current = new AbortController();
      setLoading(true);
      searchSubscription$.current = data.search.search(request, {
        strategy: 'timelineSearchStrategy',
        abortSignal: abortCtrl.current.signal
      }).subscribe({
        next: response => {
          if (!(0, _common.isRunningResponse)(response)) {
            setLoading(false);
            setTimelineLastEventTimeResponse(prevResponse => ({
              ...prevResponse,
              errorMessage: undefined,
              lastSeen: response.lastSeen,
              refetch: refetch.current
            }));
          }
        },
        error: msg => {
          setLoading(false);
          addError(msg, {
            title: i18n.FAIL_LAST_EVENT_TIME
          });
          setTimelineLastEventTimeResponse(prevResponse => ({
            ...prevResponse,
            errorMessage: msg.message
          }));
        }
      });
    };
    searchSubscription$.current.unsubscribe();
    abortCtrl.current.abort();
    asyncSearch();
    refetch.current = asyncSearch;
  }, [data.search, addError]);
  (0, _react.useEffect)(() => {
    setTimelineLastEventTimeRequest(prevRequest => {
      const myRequest = {
        ...prevRequest,
        defaultIndex: indexNames,
        indexKey,
        details
      };
      if (!(0, _fastDeepEqual.default)(prevRequest, myRequest)) {
        return myRequest;
      }
      return prevRequest;
    });
  }, [indexNames, details, indexKey]);
  (0, _react.useEffect)(() => {
    timelineLastEventTimeSearch(TimelineLastEventTimeRequest);
    return () => {
      searchSubscription$.current.unsubscribe();
      abortCtrl.current.abort();
    };
  }, [TimelineLastEventTimeRequest, timelineLastEventTimeSearch]);
  return [loading, timelineLastEventTimeResponse];
};
exports.useTimelineLastEventTime = useTimelineLastEventTime;