"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomaliesQueryTabBody = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../../../../common/constants");
var _utils = require("./utils");
var _use_installed_security_jobs = require("../../../components/ml/hooks/use_installed_security_jobs");
var _kibana = require("../../../lib/kibana");
var _matrix_histogram = require("../../../components/matrix_histogram");
var _histogram_configs = require("./histogram_configs");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/containers/anomalies/anomalies_query_tab_body/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ID = 'anomaliesHistogramQuery';
const AnomaliesQueryTabBodyComponent = ({
  deleteQuery,
  endDate,
  skip,
  startDate,
  type,
  filterQuery,
  anomaliesFilterQuery,
  AnomaliesTableComponent,
  flowTarget,
  ip,
  hostName,
  userName
}) => {
  const {
    jobs
  } = (0, _use_installed_security_jobs.useInstalledSecurityJobs)();
  const [anomalyScore] = (0, _kibana.useUiSetting$)(_constants.DEFAULT_ANOMALY_SCORE);
  const mergedFilterQuery = (0, _utils.getAnomaliesFilterQuery)(filterQuery, anomaliesFilterQuery, jobs, anomalyScore, flowTarget, ip);
  (0, _react.useEffect)(() => {
    return () => {
      if (deleteQuery) {
        deleteQuery({
          id: ID
        });
      }
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_matrix_histogram.MatrixHistogram, (0, _extends2.default)({
    endDate: endDate,
    filterQuery: mergedFilterQuery,
    id: ID,
    startDate: startDate
  }, _histogram_configs.histogramConfigs, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  })), /*#__PURE__*/_react.default.createElement(AnomaliesTableComponent, {
    startDate: startDate,
    endDate: endDate,
    skip: skip,
    type: type,
    flowTarget: flowTarget,
    ip: ip,
    hostName: hostName,
    userName: userName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }));
};
AnomaliesQueryTabBodyComponent.displayName = 'AnomaliesQueryTabBodyComponent';
const AnomaliesQueryTabBody = exports.AnomaliesQueryTabBody = /*#__PURE__*/_react.default.memo(AnomaliesQueryTabBodyComponent);
AnomaliesQueryTabBody.displayName = 'AnomaliesQueryTabBody';