"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntryItem = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _securitysolutionAutocomplete = require("@kbn/securitysolution-autocomplete");
var _use_experimental_features = require("../../hooks/use_experimental_features");
var i18n = _interopRequireWildcard(require("./translations"));
var _helpers = require("./helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/threat_match/entry_item.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LABEL_PADDING = 20;
const EntryItem = ({
  entry,
  indexPattern,
  threatIndexPatterns,
  showLabel,
  onChange,
  doesNotMatchDisabled
}) => {
  const isDoesNotMatchForIndicatorMatchRuleEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('doesNotMatchForIndicatorMatchRuleEnabled');
  const handleFieldChange = (0, _react.useCallback)(([newField]) => {
    const {
      updatedEntry,
      index
    } = (0, _helpers.getEntryOnFieldChange)(entry, newField);
    onChange(updatedEntry, index);
  }, [onChange, entry]);
  const handleThreatFieldChange = (0, _react.useCallback)(([newField]) => {
    const {
      updatedEntry,
      index
    } = (0, _helpers.getEntryOnThreatFieldChange)(entry, newField);
    onChange(updatedEntry, index);
  }, [onChange, entry]);
  const handleMatchChange = (0, _react.useCallback)(negate => {
    const {
      updatedEntry,
      index
    } = (0, _helpers.getEntryOnMatchChange)(entry, negate);
    onChange(updatedEntry, index);
  }, [onChange, entry]);
  const renderFieldInput = (0, _react.useMemo)(() => {
    var _entry$field;
    const comboBox = /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      display: "block",
      position: "top",
      content: (_entry$field = entry.field) === null || _entry$field === void 0 ? void 0 : _entry$field.name,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_securitysolutionAutocomplete.EsFieldSelector, {
      placeholder: i18n.FIELD_PLACEHOLDER,
      indexPattern: indexPattern,
      selectedField: entry.field,
      isClearable: false,
      isLoading: false,
      isDisabled: indexPattern == null,
      onChange: handleFieldChange,
      "data-test-subj": "entryField",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 9
      }
    }));
    const label = showLabel ? i18n.FIELD : '';
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: label,
      "data-test-subj": "entryItemFieldInputFormRow",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 7
      }
    }, comboBox);
  }, [handleFieldChange, indexPattern, entry, showLabel]);
  const renderMatchInput = (0, _react.useMemo)(() => {
    const options = [{
      value: 'MATCHES',
      inputDisplay: i18n.MATCHES
    }, {
      value: 'DOES_NOT_MATCH',
      inputDisplay: i18n.DOES_NOT_MATCH,
      disabled: doesNotMatchDisabled
    }];
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      "data-test-subj": "entryItemMatchInputFormRow",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
      options: options,
      valueOfSelected: entry.negate ? 'DOES_NOT_MATCH' : 'MATCHES',
      onChange: value => handleMatchChange(value === 'DOES_NOT_MATCH'),
      "aria-label": _i18n.i18n.translate('xpack.securitySolution.threatMapping.entryItem.matchOperatorAriaLabel', {
        defaultMessage: 'Match operator'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 9
      }
    }));
  }, [handleMatchChange, entry, doesNotMatchDisabled]);
  const renderThreatFieldInput = (0, _react.useMemo)(() => {
    var _entry$value;
    const comboBox = /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      display: "block",
      position: "top",
      content: (_entry$value = entry.value) === null || _entry$value === void 0 ? void 0 : _entry$value.name,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_securitysolutionAutocomplete.EsFieldSelector, {
      placeholder: i18n.FIELD_PLACEHOLDER,
      indexPattern: threatIndexPatterns,
      selectedField: entry.value,
      isClearable: false,
      isLoading: false,
      isDisabled: threatIndexPatterns == null,
      onChange: handleThreatFieldChange,
      "data-test-subj": "threatEntryField",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 9
      }
    }));
    const label = showLabel ? i18n.THREAT_FIELD : '';
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: label,
      "data-test-subj": "threatFieldInputFormRow",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 7
      }
    }, comboBox);
  }, [handleThreatFieldChange, threatIndexPatterns, entry, showLabel]);
  const matchOperatorLabel = entry.negate ? i18n.DOES_NOT_MATCH : i18n.MATCHES;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    alignItems: "center",
    justifyContent: "spaceAround",
    "data-test-subj": "itemEntryContainer",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 7
    }
  }, renderFieldInput), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    className: "eui-textCenter",
    css: (0, _react2.css)`
          padding-top: ${showLabel ? LABEL_PADDING : 0}px;
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 7
    }
  }, isDoesNotMatchForIndicatorMatchRuleEnabled ? renderMatchInput : matchOperatorLabel), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 7
    }
  }, renderThreatFieldInput));
};
exports.EntryItem = EntryItem;
EntryItem.displayName = 'EntryItem';