"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntryDeleteButtonComponent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/threat_match/entry_delete_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MyFirstRowContainer = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  padding-top: 20px;
`;
const EntryDeleteButtonComponent = exports.EntryDeleteButtonComponent = /*#__PURE__*/_react.default.memo(({
  entries,
  isOnlyItem,
  entryIndex,
  itemIndex,
  onDelete
}) => {
  const isDisabled = isOnlyItem && entries.length === 1 && itemIndex === 0 && (entries[0].field == null || entries[0].field === '');
  const handleDelete = (0, _react.useCallback)(() => {
    onDelete(entryIndex);
  }, [onDelete, entryIndex]);
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "danger",
    iconType: "trash",
    onClick: handleDelete,
    isDisabled: isDisabled,
    "aria-label": "entryDeleteButton",
    className: "itemEntryDeleteButton",
    "data-test-subj": "itemEntryDeleteButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  });
  if (entryIndex === 0 && itemIndex === 0) {
    // This logic was added to work around it including the field
    // labels in centering the delete icon for the first row
    return /*#__PURE__*/_react.default.createElement(MyFirstRowContainer, {
      grow: false,
      "data-test-subj": "firstRowDeleteButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 9
      }
    }, button);
  } else {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      "data-test-subj": "deleteButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 9
      }
    }, button);
  }
});
EntryDeleteButtonComponent.displayName = 'EntryDeleteButton';