"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useScrollToTop = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * containerSelector: The element with scrolling. It defaults to the window.
 * shouldScroll: It should be used for conditional scrolling.
 */
const useScrollToTop = (containerSelector, shouldScroll = true) => {
  (0, _react.useEffect)(() => {
    const container = containerSelector ? document.querySelector(containerSelector) : window;
    if (!shouldScroll || !container) return;

    // trying to use new API - https://developer.mozilla.org/en-US/docs/Web/API/Window/scrollTo
    if (container.scroll) {
      container.scroll(0, 0);
    } else {
      // just a fallback for older browsers
      container.scrollTo(0, 0);
    }
  });

  // renders nothing, since nothing is needed
  return null;
};
exports.useScrollToTop = useScrollToTop;