"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInvalidateFetchRecognizerQuery = exports.useFetchRecognizerQuery = exports.GET_RECOGNIZER_QUERY_KEY = void 0;
var _reactQuery = require("@tanstack/react-query");
var _react = require("react");
var _api = require("../api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ONE_MINUTE = 60000;
const GET_RECOGNIZER_QUERY_KEY = exports.GET_RECOGNIZER_QUERY_KEY = ['GET', '/internal/ml/modules/recognize/:indexPatterns'];
const useFetchRecognizerQuery = (queryArgs, options) => {
  return (0, _reactQuery.useQuery)([GET_RECOGNIZER_QUERY_KEY, queryArgs], async ({
    signal
  }) => (0, _api.checkRecognizer)({
    signal,
    ...queryArgs
  }), {
    refetchIntervalInBackground: false,
    staleTime: ONE_MINUTE * 5,
    retry: false,
    ...options
  });
};
exports.useFetchRecognizerQuery = useFetchRecognizerQuery;
const useInvalidateFetchRecognizerQuery = () => {
  const queryClient = (0, _reactQuery.useQueryClient)();
  return (0, _react.useCallback)(() => {
    queryClient.invalidateQueries(GET_RECOGNIZER_QUERY_KEY, {
      refetchType: 'active'
    });
  }, [queryClient]);
};
exports.useInvalidateFetchRecognizerQuery = useInvalidateFetchRecognizerQuery;