"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tryParseResponse = exports.throwIfErrorAttachedToSetup = exports.throwIfErrorAttached = void 0;
var i18n = _interopRequireWildcard(require("./translations"));
var _toasters = require("../../toasters");
var _errors = require("./errors");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const tryParseResponse = response => {
  try {
    return JSON.stringify(JSON.parse(response), null, 2);
  } catch (error) {
    return response;
  }
};
exports.tryParseResponse = tryParseResponse;
const throwIfErrorAttachedToSetup = (setupResponse, jobIdErrorFilter = []) => {
  const jobErrors = setupResponse.jobs.reduce((accum, job) => {
    if (job.error != null && jobIdErrorFilter.includes(job.id)) {
      if ((0, _errors.isMlStartJobError)(job)) {
        return [...accum, job.error.msg, tryParseResponse(job.error.response), `${i18n.STATUS_CODE} ${job.error.statusCode}`];
      } else if ((0, _errors.isUnknownError)(job)) {
        return [job.error.error.reason];
      }
    }
    return accum;
  }, []);
  const dataFeedErrors = setupResponse.datafeeds.reduce((accum, dataFeed) => dataFeed.error != null && jobIdErrorFilter.includes(dataFeed.id.substr('datafeed-'.length)) ? [...accum, dataFeed.error.msg, tryParseResponse(dataFeed.error.response), `${i18n.STATUS_CODE} ${dataFeed.error.statusCode}`] : accum, []);
  const errors = [...jobErrors, ...dataFeedErrors];
  if (errors.length > 0) {
    throw new _toasters.ToasterError(errors);
  }
};
exports.throwIfErrorAttachedToSetup = throwIfErrorAttachedToSetup;
const throwIfErrorAttached = (json, dataFeedIds) => {
  const errors = dataFeedIds.reduce((accum, dataFeedId) => {
    const dataFeed = json[dataFeedId];
    if ((0, _errors.isMlStartJobError)(dataFeed)) {
      return [...accum, dataFeed.error.msg, tryParseResponse(dataFeed.error.response), `${i18n.STATUS_CODE} ${dataFeed.error.statusCode}`];
    } else if ((0, _errors.isUnknownError)(dataFeed)) {
      return [dataFeed.error.error.reason];
    } else {
      return accum;
    }
  }, []);
  if (errors.length > 0) {
    throw new _toasters.ToasterError(errors);
  }
};
exports.throwIfErrorAttached = throwIfErrorAttached;