"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimelineParser = void 0;
var _rison = require("@kbn/rison");
var _queryString = require("query-string");
var _constants = require("./constants");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TimelineParser = function () {
  const Parser = this.Parser;
  const tokenizers = Parser.prototype.inlineTokenizers;
  const methods = Parser.prototype.inlineMethods;
  const parseTimeline = function (eat, value, silent) {
    let index = 0;
    const nextChar = value[index];
    if (nextChar !== '[') {
      return false;
    }
    if (silent) {
      return true;
    }
    function readArg(open, close) {
      if (value[index] !== open) {
        throw new Error(i18n.NO_PARENTHESES);
      }
      index++;
      let body = '';
      let openBrackets = 0;
      for (; index < value.length; index++) {
        const char = value[index];
        if (char === close && openBrackets === 0) {
          index++;
          return body;
        } else if (char === close) {
          openBrackets--;
        } else if (char === open) {
          openBrackets++;
        }
        body += char;
      }
      return '';
    }
    const timelineTitle = readArg('[', ']');
    const timelineUrl = readArg('(', ')');
    const now = eat.now();
    if (!timelineTitle) {
      this.file.info(i18n.NO_TIMELINE_NAME_FOUND, {
        line: now.line,
        column: now.column
      });
      return false;
    }
    try {
      var _parseTimelineUrlSear;
      const timelineSearch = timelineUrl.split('?');
      const parseTimelineUrlSearch = (0, _queryString.parse)(timelineSearch[1]);
      const decodedTimeline = (0, _rison.safeDecode)((_parseTimelineUrlSear = parseTimelineUrlSearch.timeline) !== null && _parseTimelineUrlSear !== void 0 ? _parseTimelineUrlSear : '');
      const {
        id: timelineId = ''
      } = decodedTimeline !== null && decodedTimeline !== void 0 ? decodedTimeline : {
        id: null
      };
      if (!timelineId) {
        this.file.info(i18n.NO_TIMELINE_ID_FOUND, {
          line: now.line,
          column: now.column + timelineUrl.indexOf('id')
        });
        return false;
      }
      return eat(`[${timelineTitle}](${timelineUrl})`)({
        type: _constants.ID,
        id: timelineId,
        title: timelineTitle
      });
    } catch {
      this.file.info(i18n.TIMELINE_URL_IS_NOT_VALID(timelineUrl), {
        line: now.line,
        column: now.column
      });
    }
    return false;
  };
  const tokenizeTimeline = function tokenizeTimeline(eat, value, silent) {
    if (value.startsWith(_constants.PREFIX) === false || value.startsWith(_constants.PREFIX) === true && !value.includes('timelines?timeline=(id')) {
      return false;
    }
    return parseTimeline.call(this, eat, value, silent);
  };
  tokenizeTimeline.locator = (value, fromIndex) => {
    return value.indexOf(_constants.PREFIX, fromIndex);
  };
  tokenizers.timeline = tokenizeTimeline;
  methods.splice(methods.indexOf('url'), 0, _constants.ID);
};
exports.TimelineParser = TimelineParser;