"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isProviderValid = isProviderValid;
exports.validateProvider = validateProvider;
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _valid = _interopRequireDefault(require("semver/functions/valid"));
var _common = require("@kbn/data-plugin/common");
var _fieldTypes = require("@kbn/field-types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function validateProvider(dataViewField, value, valueType) {
  var _dataViewField$esType;
  if (value === undefined || valueType === 'undefined') {
    return false;
  }
  const fieldType = dataViewField.type;
  switch (fieldType) {
    case 'date':
      const moment = typeof value === 'string' ? _datemath.default.parse(value) : null;
      return Boolean(typeof value === 'string' && moment && moment.isValid());
    case 'ip':
      if (typeof value === 'string' || typeof value === 'number') {
        try {
          return Boolean(new _common.IpAddress(value));
        } catch (e) {
          return false;
        }
      }
      return false;
    case 'string':
      if (typeof value === 'string' && (_dataViewField$esType = dataViewField.esTypes) !== null && _dataViewField$esType !== void 0 && _dataViewField$esType.includes(_fieldTypes.ES_FIELD_TYPES.VERSION)) {
        return Boolean((0, _valid.default)(value));
      }
      return typeof value === 'string' && value.trim().length > 0;
    case 'boolean':
      return typeof value === 'boolean';
    case 'number':
      return typeof value === 'number' || typeof value === 'string' && !isNaN(parseFloat(value));
    default:
      return true;
  }
}
function isProviderValid(provider, dataViewField) {
  if (!dataViewField || !provider.field) {
    return false;
  }
  switch (provider.queryType) {
    case 'phrase':
      return validateProvider(dataViewField, provider.value, provider.valueType);
    case 'phrases':
      const phraseArray = typeof provider.value === 'string' ? JSON.parse(`${provider.value}`) : null;
      if (!Array.isArray(phraseArray) || !phraseArray.length) {
        return false;
      }
      return phraseArray.every(phrase => validateProvider(dataViewField, phrase, provider.valueType));
    case 'range':
      const rangeObject = JSON.parse(typeof provider.value === 'string' ? provider.value : '');
      if (typeof rangeObject !== 'object') {
        return false;
      }
      return (!rangeObject.gte || validateProvider(dataViewField, rangeObject.gte, provider.valueType)) && (!rangeObject.lt || validateProvider(dataViewField, rangeObject.lt, provider.valueType));
    case 'exists':
      return true;
    default:
      throw new Error(`Unknown operator type: ${provider.queryType}`);
  }
}