"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SOLUTION_REQUIREMENTS_LINK_TEXT = exports.SOLUTION_REQUIREMENTS_LINK_PATH = exports.ML_JOB_COMPATIBILITY_LINK_TEXT = exports.ML_JOB_COMPATIBILITY_LINK_PATH = exports.DETECTIONS_REQUIREMENTS_LINK_TEXT = exports.DETECTIONS_REQUIREMENTS_LINK_PATH = exports.COVERAGE_OVERVIEW_LINK_TEXT = exports.COVERAGE_OVERVIEW_LINK_PATH = exports.COMMON_ARIA_LABEL_ENDING = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * If a link's text is "Docs", its aria-label will be set to
 * "Docs - ${COMMON_ARIA_LABEL_ENDING}".
 */
const COMMON_ARIA_LABEL_ENDING = exports.COMMON_ARIA_LABEL_ENDING = _i18n.i18n.translate('xpack.securitySolution.documentationLinks.ariaLabelEnding', {
  defaultMessage: 'click to open documentation in a new tab'
});
const SOLUTION_REQUIREMENTS_LINK_PATH = exports.SOLUTION_REQUIREMENTS_LINK_PATH = 'sec-requirements.html';
const SOLUTION_REQUIREMENTS_LINK_TEXT = exports.SOLUTION_REQUIREMENTS_LINK_TEXT = _i18n.i18n.translate('xpack.securitySolution.documentationLinks.solutionRequirements.text', {
  defaultMessage: 'Elastic Security system requirements'
});
const DETECTIONS_REQUIREMENTS_LINK_PATH = exports.DETECTIONS_REQUIREMENTS_LINK_PATH = 'detections-permissions-section.html';
const DETECTIONS_REQUIREMENTS_LINK_TEXT = exports.DETECTIONS_REQUIREMENTS_LINK_TEXT = _i18n.i18n.translate('xpack.securitySolution.documentationLinks.detectionsRequirements.text', {
  defaultMessage: 'Detections prerequisites and requirements'
});
const ML_JOB_COMPATIBILITY_LINK_PATH = exports.ML_JOB_COMPATIBILITY_LINK_PATH = 'alerts-ui-monitor.html#ml-job-compatibility';
const ML_JOB_COMPATIBILITY_LINK_TEXT = exports.ML_JOB_COMPATIBILITY_LINK_TEXT = _i18n.i18n.translate('xpack.securitySolution.documentationLinks.mlJobCompatibility.text', {
  defaultMessage: 'ML job compatibility'
});
const COVERAGE_OVERVIEW_LINK_PATH = exports.COVERAGE_OVERVIEW_LINK_PATH = 'rules-coverage.html';
const COVERAGE_OVERVIEW_LINK_TEXT = exports.COVERAGE_OVERVIEW_LINK_TEXT = _i18n.i18n.translate('xpack.securitySolution.documentationLinks.coverageOverview.text', {
  defaultMessage: 'Learn more.'
});