"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCreateCaseUrl = exports.getConfigureCasesUrl = exports.getCaseUrl = exports.getCaseDetailsUrlWithCommentId = exports.getCaseDetailsUrl = void 0;
var _helpers = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCaseUrl = search => `${(0, _helpers.appendSearch)(search !== null && search !== void 0 ? search : undefined)}`;
exports.getCaseUrl = getCaseUrl;
const getCaseDetailsUrl = ({
  id,
  search
}) => {
  return `/${encodeURIComponent(id)}${(0, _helpers.appendSearch)(search !== null && search !== void 0 ? search : undefined)}`;
};
exports.getCaseDetailsUrl = getCaseDetailsUrl;
const getCaseDetailsUrlWithCommentId = ({
  id,
  commentId,
  search
}) => {
  return `/${encodeURIComponent(id)}/${encodeURIComponent(commentId)}${(0, _helpers.appendSearch)(search !== null && search !== void 0 ? search : undefined)}`;
};
exports.getCaseDetailsUrlWithCommentId = getCaseDetailsUrlWithCommentId;
const getCreateCaseUrl = search => `/create${(0, _helpers.appendSearch)(search !== null && search !== void 0 ? search : undefined)}`;
exports.getCreateCaseUrl = getCreateCaseUrl;
const getConfigureCasesUrl = search => `/configure${(0, _helpers.appendSearch)(search !== null && search !== void 0 ? search : undefined)}`;
exports.getConfigureCasesUrl = getConfigureCasesUrl;