"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useWithCaseDetailsRefresh = exports.CaseDetailsRefreshContext = void 0;
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * React Context that can hold the `Ref` that is created an passed to `CaseViewProps['refreshRef`]`, enabling
 * child components to trigger a refresh of a case.
 */
const CaseDetailsRefreshContext = exports.CaseDetailsRefreshContext = /*#__PURE__*/_react.default.createContext(null);

/**
 * Returns the closes CaseDetails Refresh interface if any. Used in conjuction with `CaseDetailsRefreshContext` component
 *
 * @example
 * // Higher-order component
 * const refreshRef = useRef<CaseViewRefreshPropInterface>(null);
 * return <CaseDetailsRefreshContext.Provider value={refreshRef}>....</CaseDetailsRefreshContext.Provider>
 *
 * // Now, use the hook from a hild component that was rendered inside of `<CaseDetailsRefreshContext.Provider>`
 * const caseDetailsRefresh = useWithCaseDetailsRefresh();
 * ...
 * if (caseDetailsRefresh) {
 *   caseDetailsRefresh.refreshCase();
 * }
 */
const useWithCaseDetailsRefresh = () => {
  var _useContext;
  return (_useContext = (0, _react.useContext)(CaseDetailsRefreshContext)) === null || _useContext === void 0 ? void 0 : _useContext.current;
};
exports.useWithCaseDetailsRefresh = useWithCaseDetailsRefresh;