"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHostIsolationAction = void 0;
var _react = require("react");
var _responder = require("../../responder");
var _use_alert_response_actions_support = require("../../../../hooks/endpoint/use_alert_response_actions_support");
var _types = require("../../../../../../common/endpoint/types");
var _translations = require("./translations");
var _user_privileges = require("../../../user_privileges");
var _use_get_agent_status = require("../../../../../management/hooks/agents/use_get_agent_status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const emptyArray = [];
const useHostIsolationAction = ({
  closePopover,
  detailsData,
  isHostIsolationPanelOpen,
  onAddIsolationStatusClick
}) => {
  const {
    isSupported: hostSupportsResponseActions,
    unsupportedReason,
    details: {
      agentType,
      agentId,
      agentSupport: {
        isolate: isolationSupported
      }
    }
  } = (0, _use_alert_response_actions_support.useAlertResponseActionsSupport)(detailsData);
  const {
    canIsolateHost,
    canUnIsolateHost
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const {
    data,
    isLoading,
    isFetched
  } = (0, _use_get_agent_status.useGetAgentStatus)(agentId, agentType, {
    enabled: hostSupportsResponseActions
  });
  const agentStatus = data === null || data === void 0 ? void 0 : data[agentId];
  const doesHostSupportIsolation = (0, _react.useMemo)(() => {
    return hostSupportsResponseActions && isolationSupported;
  }, [hostSupportsResponseActions, isolationSupported]);
  const isHostIsolated = (0, _react.useMemo)(() => {
    return Boolean(agentStatus === null || agentStatus === void 0 ? void 0 : agentStatus.isolated);
  }, [agentStatus === null || agentStatus === void 0 ? void 0 : agentStatus.isolated]);
  const isolateHostHandler = (0, _react.useCallback)(() => {
    closePopover();
    if (doesHostSupportIsolation) {
      if (!isHostIsolated) {
        onAddIsolationStatusClick('isolateHost');
      } else {
        onAddIsolationStatusClick('unisolateHost');
      }
    }
  }, [closePopover, doesHostSupportIsolation, isHostIsolated, onAddIsolationStatusClick]);
  const isHostAgentUnEnrolled = (0, _react.useMemo)(() => {
    return !hostSupportsResponseActions || !(agentStatus !== null && agentStatus !== void 0 && agentStatus.found) || agentStatus.status === _types.HostStatus.UNENROLLED;
  }, [hostSupportsResponseActions, agentStatus]);
  return (0, _react.useMemo)(() => {
    // If user has no Authz, then don't show the menu item at all
    if (isHostIsolated && !canUnIsolateHost || !canIsolateHost) {
      return emptyArray;
    }
    const menuItem = {
      key: 'isolate-host-action-item',
      'data-test-subj': 'isolate-host-action-item',
      disabled: isHostAgentUnEnrolled || isHostIsolationPanelOpen,
      onClick: isolateHostHandler,
      name: isHostIsolated ? _translations.UNISOLATE_HOST : _translations.ISOLATE_HOST
    };

    // Determine if menu item should be disabled
    if (!doesHostSupportIsolation) {
      menuItem.disabled = true;
      // If we were able to calculate the agentType and we have a reason why the host is does not
      // support response actions, then show that as the tooltip. Else, just show the normal "enroll" message
      menuItem.toolTipContent = agentType && unsupportedReason ? unsupportedReason : _responder.NOT_FROM_ENDPOINT_HOST_TOOLTIP;
    } else if (isLoading || !isFetched) {
      menuItem.disabled = true;
      menuItem.toolTipContent = _responder.LOADING_ENDPOINT_DATA_TOOLTIP;
    } else if (isHostAgentUnEnrolled) {
      menuItem.disabled = true;
      menuItem.toolTipContent = agentType === 'endpoint' ? _responder.HOST_ENDPOINT_UNENROLLED_TOOLTIP : _responder.NOT_FROM_ENDPOINT_HOST_TOOLTIP;
    }
    return [menuItem];
  }, [isHostIsolated, canUnIsolateHost, canIsolateHost, isHostAgentUnEnrolled, isHostIsolationPanelOpen, isolateHostHandler, doesHostSupportIsolation, isLoading, isFetched, agentType, unsupportedReason]);
};
exports.useHostIsolationAction = useHostIsolationAction;