"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDiscoverInTimelineContext = void 0;
var _react = require("react");
var _context = require("./context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDiscoverInTimelineContext = () => {
  const discoverContext = (0, _react.useContext)(_context.DiscoverInTimelineContext);
  if (!discoverContext) {
    const errMessage = `useDiscoverInTimelineContext should only used within a tree with parent as DiscoverInTimelineContextProvider`;
    throw new Error(errMessage);
  }
  return discoverContext;
};
exports.useDiscoverInTimelineContext = useDiscoverInTimelineContext;