"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AreaChartComponent = exports.AreaChartBaseComponent = exports.AreaChartBase = exports.AreaChart = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _charts = require("@elastic/charts");
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _utils = require("../utils");
var _chart_place_holder = require("./chart_place_holder");
var _kibana = require("../../lib/kibana");
var _common = require("./common");
var _actions = require("../visualization_actions/actions");
var _hover_visibility_container = require("../hover_visibility_container");
var _utils2 = require("../visualization_actions/utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/charts/areachart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// custom series styles: https://ela.st/areachart-styling
const getSeriesLineStyle = () => {
  return {
    area: {
      opacity: 0.04,
      visible: true
    },
    line: {
      strokeWidth: 1,
      visible: true
    },
    point: {
      visible: 'never',
      radius: 0.2,
      strokeWidth: 1,
      opacity: 1
    }
  };
};
const checkIfAllTheDataInTheSeriesAreValid = series => !!(0, _fp.get)('value.length', series) && (0, _fp.get)('value', series).every(({
  x,
  y
}) => !(0, _fp.isNull)(x) && (0, _fp.isNumber)(y) && y > 0);
const checkIfAnyValidSeriesExist = data => Array.isArray(data) && data.some(checkIfAllTheDataInTheSeriesAreValid);
const axisStyle = {
  tickLine: {
    visible: false
  },
  tickLabel: {
    padding: 3
  }
};

// https://ela.st/multi-areaseries
const AreaChartBaseComponent = ({
  data,
  ...chartConfigs
}) => {
  const themes = (0, _common.useThemes)();
  const timeZone = (0, _kibana.useTimeZone)();
  const xTickFormatter = (0, _fp.get)('configs.axis.xTickFormatter', chartConfigs);
  const yTickFormatter = (0, _fp.get)('configs.axis.yTickFormatter', chartConfigs);
  const xAxisId = `group-${data[0].key}-x`;
  const yAxisId = `group-${data[0].key}-y`;
  const settings = {
    locale: _i18n.i18n.getLocale(),
    ..._common.chartDefaultSettings,
    ...themes,
    ...(0, _fp.get)('configs.settings', chartConfigs)
  };
  return chartConfigs.width && chartConfigs.height ? /*#__PURE__*/_react.default.createElement("div", {
    style: {
      height: chartConfigs.height,
      width: chartConfigs.width,
      position: 'relative'
    },
    "data-test-subj": "areaChartBaseComponent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, (0, _extends2.default)({}, settings, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 9
    }
  })), data.map(series => {
    const seriesKey = series.key;
    return checkIfAllTheDataInTheSeriesAreValid(series) ? /*#__PURE__*/_react.default.createElement(_charts.AreaSeries, {
      id: seriesKey,
      key: seriesKey,
      name: series.key.replace('Histogram', ''),
      data: series.value || [],
      xScaleType: (0, _fp.getOr)(_charts.ScaleType.Linear, 'configs.series.xScaleType', chartConfigs),
      yScaleType: (0, _fp.getOr)(_charts.ScaleType.Linear, 'configs.series.yScaleType', chartConfigs),
      timeZone: timeZone,
      xAccessor: "x",
      yAccessors: ['y'],
      areaSeriesStyle: getSeriesLineStyle(),
      color: series.color ? series.color : undefined,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 13
      }
    }) : null;
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: xAxisId,
    position: _charts.Position.Bottom,
    showOverlappingTicks: false,
    tickFormat: xTickFormatter,
    style: axisStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: yAxisId,
    position: _charts.Position.Left,
    style: axisStyle,
    tickFormat: yTickFormatter,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 9
    }
  }))) : null;
};
exports.AreaChartBaseComponent = AreaChartBaseComponent;
AreaChartBaseComponent.displayName = 'AreaChartBaseComponent';
const AreaChartBase = exports.AreaChartBase = /*#__PURE__*/_react.default.memo(AreaChartBaseComponent);
AreaChartBase.displayName = 'AreaChartBase';
const AreaChartComponent = ({
  areaChart,
  configs,
  visualizationActionsOptions
}) => {
  const {
    ref: measureRef,
    width,
    height
  } = (0, _utils.useThrottledResizeObserver)();
  const customHeight = (0, _fp.get)('customHeight', configs);
  const customWidth = (0, _fp.get)('customWidth', configs);
  const chartHeight = (0, _common.getChartHeight)(customHeight, height);
  const chartWidth = (0, _common.getChartWidth)(customWidth, width);
  const isValidSeriesExist = (0, _react.useMemo)(() => checkIfAnyValidSeriesExist(areaChart), [areaChart]);
  return /*#__PURE__*/_react.default.createElement(_common.Wrapper, {
    "data-test-subj": "areaChartComponent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_hover_visibility_container.HoverVisibilityContainer, {
    targetClassNames: [_utils2.VISUALIZATION_ACTIONS_BUTTON_CLASS],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 7
    }
  }, isValidSeriesExist && areaChart && /*#__PURE__*/_react.default.createElement(_common.ChartWrapper, {
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_common.WrappedByAutoSizer, {
    ref: measureRef,
    height: chartHeight,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(AreaChartBase, {
    data: areaChart,
    height: chartHeight,
    width: chartWidth,
    configs: configs,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 17
    }
  })))), !isValidSeriesExist && /*#__PURE__*/_react.default.createElement(_chart_place_holder.ChartPlaceHolder, {
    height: chartHeight,
    width: chartWidth,
    data: areaChart,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 11
    }
  }), visualizationActionsOptions != null && /*#__PURE__*/_react.default.createElement(_actions.VisualizationActions, (0, _extends2.default)({}, visualizationActionsOptions, {
    className: "viz-actions",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 11
    }
  }))));
};
exports.AreaChartComponent = AreaChartComponent;
const AreaChart = exports.AreaChart = /*#__PURE__*/_react.default.memo(AreaChartComponent);