"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  useDataGridColumnsSecurityCellActions: true,
  SecurityCellActions: true,
  SecurityCellActionsTrigger: true,
  SecurityCellActionType: true
};
Object.defineProperty(exports, "SecurityCellActionType", {
  enumerable: true,
  get: function () {
    return _constants.SecurityCellActionType;
  }
});
exports.SecurityCellActions = void 0;
Object.defineProperty(exports, "SecurityCellActionsTrigger", {
  enumerable: true,
  get: function () {
    return _constants.SecurityCellActionsTrigger;
  }
});
exports.useDataGridColumnsSecurityCellActions = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _cellActions = require("@kbn/cell-actions");
Object.keys(_cellActions).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _cellActions[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _cellActions[key];
    }
  });
});
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../../app/actions/constants");
var _model = require("../../../sourcerer/store/model");
var _use_get_field_spec = require("../../hooks/use_get_field_spec");
var _use_data_view_id = require("../../hooks/use_data_view_id");
var _use_experimental_features = require("../../hooks/use_experimental_features");
var _use_data_view = require("../../../data_view_manager/hooks/use_data_view");
var _constants2 = require("@kbn/cell-actions/constants");
Object.keys(_constants2).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _constants2[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _constants2[key];
    }
  });
});
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/cell_actions/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// bridge exports for convenience
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useDataGridColumnsSecurityCellActions = exports.useDataGridColumnsSecurityCellActions = _cellActions.useDataGridColumnsCellActions;
const SecurityCellActions = ({
  sourcererScopeId = _model.SourcererScopeName.default,
  data,
  metadata,
  children,
  ...props
}) => {
  const oldGetFieldSpec = (0, _use_get_field_spec.useGetFieldSpec)(sourcererScopeId);
  const oldDataViewId = (0, _use_data_view_id.useDataViewId)(sourcererScopeId);
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const {
    dataView: experimentalDataView
  } = (0, _use_data_view.useDataView)(sourcererScopeId);
  const dataViewId = newDataViewPickerEnabled ? experimentalDataView.id : oldDataViewId;

  // Make a dependency key to prevent unnecessary re-renders when data object is defined inline
  // It is necessary because the data object is an array or an object and useMemo would always re-render
  const dependencyKey = JSON.stringify(data);
  const fieldData = (0, _react.useMemo)(() => (Array.isArray(data) ? data : [data]).map(({
    field,
    value
  }) => {
    var _experimentalDataView, _experimentalDataView2;
    return {
      field: newDataViewPickerEnabled ? (_experimentalDataView = experimentalDataView.fields) === null || _experimentalDataView === void 0 ? void 0 : (_experimentalDataView2 = _experimentalDataView.getByName(field)) === null || _experimentalDataView2 === void 0 ? void 0 : _experimentalDataView2.toSpec() : oldGetFieldSpec(field),
      value
    };
  }).filter(item => !!item.field),
  // eslint-disable-next-line react-hooks/exhaustive-deps -- Use the dependencyKey to prevent unnecessary re-renders
  [dependencyKey, oldGetFieldSpec, newDataViewPickerEnabled, experimentalDataView.fields]);
  const metadataWithDataView = (0, _react.useMemo)(() => ({
    ...metadata,
    dataViewId
  }), [dataViewId, metadata]);
  return fieldData.length > 0 ? /*#__PURE__*/_react.default.createElement(_cellActions.CellActions, (0, _extends2.default)({
    data: fieldData,
    metadata: metadataWithDataView
  }, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 5
    }
  }), children) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
};
exports.SecurityCellActions = SecurityCellActions;