"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ASSIGNEES_SELECTION_STATUS_MESSAGE = exports.ASSIGNEES_SEARCH_USERS = exports.ASSIGNEES_NO_ASSIGNEES = exports.ASSIGNEES_CLEAR_FILTERS = exports.ASSIGNEES_APPLY_BUTTON = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ASSIGNEES_SELECTION_STATUS_MESSAGE = total => _i18n.i18n.translate('xpack.securitySolution.assignees.totalUsersAssigned', {
  defaultMessage: '{total, plural, one {# assignee} other {# assignees}} selected',
  values: {
    total
  }
});
exports.ASSIGNEES_SELECTION_STATUS_MESSAGE = ASSIGNEES_SELECTION_STATUS_MESSAGE;
const ASSIGNEES_APPLY_BUTTON = exports.ASSIGNEES_APPLY_BUTTON = _i18n.i18n.translate('xpack.securitySolution.assignees.applyButtonTitle', {
  defaultMessage: 'Apply'
});
const ASSIGNEES_SEARCH_USERS = exports.ASSIGNEES_SEARCH_USERS = _i18n.i18n.translate('xpack.securitySolution.assignees.selectableSearchPlaceholder', {
  defaultMessage: 'Search users'
});
const ASSIGNEES_CLEAR_FILTERS = exports.ASSIGNEES_CLEAR_FILTERS = _i18n.i18n.translate('xpack.securitySolution.assignees.clearFilters', {
  defaultMessage: 'Clear filters'
});
const ASSIGNEES_NO_ASSIGNEES = exports.ASSIGNEES_NO_ASSIGNEES = _i18n.i18n.translate('xpack.securitySolution.assignees.noAssigneesLabel', {
  defaultMessage: 'No assignees'
});