"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBulkAddEventsToCaseActions = void 0;
var _react = require("react");
var _common = require("@kbn/cases-plugin/common");
var _common2 = require("../../../../common");
var _kibana = require("../../../common/lib/kibana");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Utility function converting multiple timeline items into single attachment (when attaching multiple timeline items to a case)
 */
const timelineItemsToCaseEventAttachment = timelineItems => {
  return {
    type: _common.AttachmentType.event,
    eventId: timelineItems.map(item => item._id).filter(Boolean),
    index: timelineItems.map(item => item._index).filter(Boolean)
  };
};

/**
 * Prepares bulk actions related to case event attachments
 */
const useBulkAddEventsToCaseActions = ({
  clearSelection
}) => {
  const {
    services: {
      cases: casesService
    }
  } = (0, _kibana.useKibana)();
  const userCasesPermissions = (0, _react.useMemo)(() => {
    return casesService === null || casesService === void 0 ? void 0 : casesService.helpers.canUseCases([_common2.APP_ID]);
  }, [casesService]);
  const CasesContext = (0, _react.useMemo)(() => casesService === null || casesService === void 0 ? void 0 : casesService.ui.getCasesContext(), [casesService]);
  const isCasesContextAvailable = Boolean(casesService && CasesContext);
  const onSuccess = (0, _react.useCallback)(() => {
    clearSelection();
  }, [clearSelection]);
  const createCaseFlyout = casesService === null || casesService === void 0 ? void 0 : casesService.hooks.useCasesAddToNewCaseFlyout({
    onSuccess
  });
  const selectCaseModal = casesService === null || casesService === void 0 ? void 0 : casesService.hooks.useCasesAddToExistingCaseModal({
    onSuccess
  });
  return (0, _react.useMemo)(() => {
    return isCasesContextAvailable && createCaseFlyout && selectCaseModal && userCasesPermissions !== null && userCasesPermissions !== void 0 && userCasesPermissions.create && userCasesPermissions !== null && userCasesPermissions !== void 0 && userCasesPermissions.read ? [{
      label: _translations.ADD_TO_NEW_CASE,
      key: 'attach-new-case',
      'data-test-subj': 'attach-new-case',
      disableOnQuery: true,
      disabledLabel: _translations.ADD_TO_NEW_CASE,
      onClick: (events = []) => createCaseFlyout.open({
        attachments: [timelineItemsToCaseEventAttachment(events)]
      })
    }, {
      label: _translations.ADD_TO_EXISTING_CASE,
      key: 'attach-existing-case',
      disableOnQuery: true,
      disabledLabel: _translations.ADD_TO_EXISTING_CASE,
      'data-test-subj': 'attach-existing-case',
      onClick: (events = []) => selectCaseModal.open({
        getAttachments: () => [timelineItemsToCaseEventAttachment(events)]
      })
    }] : [];
  }, [createCaseFlyout, isCasesContextAvailable, selectCaseModal, userCasesPermissions === null || userCasesPermissions === void 0 ? void 0 : userCasesPermissions.create, userCasesPermissions === null || userCasesPermissions === void 0 ? void 0 : userCasesPermissions.read]);
};
exports.useBulkAddEventsToCaseActions = useBulkAddEventsToCaseActions;