"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventsTableForCases = exports.EVENTS_TABLE_FOR_CASES_ID = void 0;
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _styledComponents = require("styled-components");
var _constants = require("../../../app/actions/constants");
var _row_action = require("../../../common/components/control_columns/row_action");
var _build_browser_fields = require("../../../data_view_manager/utils/build_browser_fields");
var _control_columns = require("../../../timelines/components/timeline/body/control_columns");
var _renderers = require("../../../timelines/components/timeline/body/renderers");
var _default_cell_renderer = require("../../../timelines/components/timeline/cell_rendering/default_cell_renderer");
var _use_get_events = require("./use_get_events");
var _use_events_data_view = require("./use_events_data_view");
var _translations = require("./translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/cases/components/case_events/table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EVENTS_TABLE_FOR_CASES_ID = exports.EVENTS_TABLE_FOR_CASES_ID = 'EVENTS_TABLE_FOR_CASES_ID';
const noop = () => {};
const emptyObject = {};
const MAX_ACTION_BUTTON_COUNT = 4;
const DEFAULT_MODEL = structuredClone(_securitysolutionDataTable.tableDefaults);
const EventsTableForCasesBody = ({
  dataView,
  events
}) => {
  const selectTableById = (0, _react.useMemo)(() => (0, _securitysolutionDataTable.getTableByIdSelector)(), []);
  const {
    defaultColumns,
    columns,
    loadingEventIds,
    itemsPerPage,
    itemsPerPageOptions,
    sort
  } = (0, _reactRedux.useSelector)(state => {
    var _selectTableById;
    return (_selectTableById = selectTableById(state, EVENTS_TABLE_FOR_CASES_ID)) !== null && _selectTableById !== void 0 ? _selectTableById : DEFAULT_MODEL;
  });
  const dispatch = (0, _reactRedux.useDispatch)();
  const browserFields = (0, _react.useMemo)(() => (0, _build_browser_fields.buildBrowserFields)(dataView.fields), [dataView.fields]);
  const controlColumns = (0, _react.useMemo)(() => (0, _control_columns.getDefaultControlColumn)(MAX_ACTION_BUTTON_COUNT), []);
  const [currentPageIndex, setCurrentPageIndex] = (0, _react.useState)(0);
  (0, _react.useEffect)(() => {
    dispatch(_securitysolutionDataTable.dataTableActions.createDataTable({
      indexNames: dataView.getIndexPattern().split(','),
      columns,
      defaultColumns,
      sort,
      id: EVENTS_TABLE_FOR_CASES_ID
    }));
  }, [columns, defaultColumns, dispatch, dataView, sort]);
  const theme = (0, _react.useContext)(_styledComponents.ThemeContext);
  const pagination = (0, _react.useMemo)(() => ({
    pageIndex: currentPageIndex,
    pageSize: itemsPerPage,
    pageSizeOptions: itemsPerPageOptions,
    onChangeItemsPerPage: perPage => dispatch(_securitysolutionDataTable.dataTableActions.updateItemsPerPage({
      id: EVENTS_TABLE_FOR_CASES_ID,
      itemsPerPage: perPage
    })),
    onChangePage: setCurrentPageIndex
  }), [currentPageIndex, dispatch, itemsPerPage, itemsPerPageOptions]);
  const eventIds = (0, _react.useMemo)(() => {
    return events.flatMap(event => Array.isArray(event.eventId) ? event.eventId : [event.eventId]);
  }, [events]);
  const {
    data = []
  } = (0, _use_get_events.useGetEvents)(dataView, {
    eventIds,
    sort,
    pageIndex: currentPageIndex,
    itemsPerPage
  });

  // NOTE: sorting change resets pagination
  (0, _react.useEffect)(() => {
    setCurrentPageIndex(0);
  }, [sort]);
  const leadingControlColumns = (0, _react.useMemo)(() => (0, _control_columns.getDefaultControlColumn)(MAX_ACTION_BUTTON_COUNT).map((column, i) => ({
    ...column,
    headerCellRender: () => null,
    rowCellRender: ({
      isDetails,
      isExpandable,
      isExpanded,
      rowIndex,
      colIndex,
      setCellProps
    }) => {
      var _column$id;
      const pageRowIndex = (0, _securitysolutionDataTable.getPageRowIndex)(rowIndex, itemsPerPage);
      const rowData = data[pageRowIndex];
      if (rowData) {
        (0, _securitysolutionDataTable.addBuildingBlockStyle)(rowData.ecs, theme, setCellProps);
      } else {
        // disable the cell when it has no data
        setCellProps({
          style: {
            display: 'none'
          }
        });
      }
      return /*#__PURE__*/_react.default.createElement(_row_action.RowAction, {
        key: column.id,
        columnId: (_column$id = column.id) !== null && _column$id !== void 0 ? _column$id : '',
        columnHeaders: _securitysolutionDataTable.defaultHeaders,
        controlColumn: controlColumns[i],
        data: rowData,
        disabled: false,
        index: i,
        rowIndex: rowIndex,
        colIndex: colIndex,
        isDetails: isDetails,
        isExpanded: isExpanded,
        isEventViewer: false,
        isExpandable: isExpandable,
        loadingEventIds: loadingEventIds,
        onRowSelected: noop,
        onRuleChange: noop,
        pageRowIndex: pageRowIndex,
        selectedEventIds: emptyObject,
        setCellProps: setCellProps,
        showCheckboxes: false,
        tableId: EVENTS_TABLE_FOR_CASES_ID,
        width: 100,
        setEventsLoading: noop,
        setEventsDeleted: noop,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 141,
          columnNumber: 13
        }
      });
    }
  })), [controlColumns, data, itemsPerPage, loadingEventIds, theme]);
  const getFieldSpec = (0, _react.useCallback)(fieldName => {
    var _dataView$fields$getB;
    return (_dataView$fields$getB = dataView.fields.getByName(fieldName)) === null || _dataView$fields$getB === void 0 ? void 0 : _dataView$fields$getB.toSpec();
  }, [dataView.fields]);
  return /*#__PURE__*/_react.default.createElement(_securitysolutionDataTable.DataTableComponent, {
    browserFields: browserFields,
    data: data,
    getFieldSpec: getFieldSpec,
    id: EVENTS_TABLE_FOR_CASES_ID,
    totalItems: eventIds.length,
    unitCountText: _translations.TABLE_UNIT,
    cellActionsTriggerId: _constants.SecurityCellActionsTrigger.CASE_EVENTS,
    leadingControlColumns: leadingControlColumns,
    loadPage: noop,
    pagination: pagination,
    renderCellValue: _default_cell_renderer.DefaultCellRenderer,
    rowRenderers: _renderers.defaultRowRenderers,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 5
    }
  });
};
const EventsTableForCases = ({
  events
}) => {
  const patterns = (0, _react.useMemo)(() => [...new Set(events.flatMap(event => Array.isArray(event.index) ? event.index : [event.index]))].join(), [events]);
  const {
    dataView
  } = (0, _use_events_data_view.useCaseEventsDataView)(patterns);
  if (!dataView) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(EventsTableForCasesBody, {
    dataView: dataView,
    events: events,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 10
    }
  });
};
exports.EventsTableForCases = EventsTableForCases;