"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertFormDataInBaseSchedule = void 0;
var _common = require("@kbn/data-plugin/common");
var _kuery = require("../../../../../common/lib/kuery");
var _helpers = require("../../../use_attack_discovery/helpers");
var _parse_filter_query = require("../../parse_filter_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const convertFormDataInBaseSchedule = (scheduleData, alertsIndexPattern, connector, dataViewSpec, uiSettings, dataView) => {
  const alertsSelectionSettings = scheduleData.alertsSelectionSettings;
  const [filterQuery, kqlError] = (0, _kuery.convertToBuildEsQuery)({
    config: (0, _common.getEsQueryConfig)(uiSettings),
    dataViewSpec,
    dataView,
    queries: [alertsSelectionSettings.query],
    filters: alertsSelectionSettings.filters
  });
  const combinedFilter = (0, _parse_filter_query.parseFilterQuery)({
    filterQuery,
    kqlError
  });
  const genAiConfig = (0, _helpers.getGenAiConfig)(connector);
  const apiConfig = {
    connectorId: connector.id,
    name: connector.name,
    actionTypeId: connector.actionTypeId,
    provider: connector.apiProvider,
    model: genAiConfig === null || genAiConfig === void 0 ? void 0 : genAiConfig.defaultModel
  };
  return {
    name: scheduleData.name,
    enabled: true,
    params: {
      alertsIndexPattern: alertsIndexPattern !== null && alertsIndexPattern !== void 0 ? alertsIndexPattern : '',
      apiConfig,
      end: alertsSelectionSettings.end,
      query: alertsSelectionSettings.query,
      filters: alertsSelectionSettings.filters,
      combinedFilter,
      size: alertsSelectionSettings.size,
      start: alertsSelectionSettings.start
    },
    schedule: {
      interval: scheduleData.interval
    },
    actions: scheduleData.actions
  };
};
exports.convertFormDataInBaseSchedule = convertFormDataInBaseSchedule;