"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DESCRIPTION_PLACEHOLDER = exports.ConnectorFilter = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _get_description = require("./get_description");
var i18n = _interopRequireWildcard(require("../translations"));
var _use_find_attack_discoveries = require("../../../../use_find_attack_discoveries");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/attack_discovery/pages/results/history/search_and_filter/connector_filter/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DESCRIPTION_PLACEHOLDER = exports.DESCRIPTION_PLACEHOLDER = '-';
const LIST_PROPS = {
  isVirtualized: false,
  rowHeight: 60
};
const ConnectorFilterComponent = ({
  aiConnectors,
  connectorNames,
  isLoading = false,
  selectedConnectorNames,
  setSelectedConnectorNames
}) => {
  const invalidateFindAttackDiscoveries = (0, _use_find_attack_discoveries.useInvalidateFindAttackDiscoveries)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react2.useState)(false);
  const onFilterButtonClick = (0, _react2.useCallback)(() => {
    setIsPopoverOpen(isOpen => !isOpen);
  }, []);
  const closePopover = (0, _react2.useCallback)(() => {
    setIsPopoverOpen(false);
  }, []);
  const filterGroupPopoverId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'connectorFilterGroupPopover'
  });
  const connectorFilterItems = (0, _react2.useMemo)(() => {
    var _connectorNames$map;
    return (_connectorNames$map = connectorNames === null || connectorNames === void 0 ? void 0 : connectorNames.map(name => {
      var _getDescription;
      const connector = aiConnectors === null || aiConnectors === void 0 ? void 0 : aiConnectors.find(x => x.name === name);
      const checked = (selectedConnectorNames === null || selectedConnectorNames === void 0 ? void 0 : selectedConnectorNames.find(x => x === name)) !== undefined;
      return {
        checked: checked ? 'on' : undefined,
        data: {
          description: (_getDescription = (0, _get_description.getDescription)(connector === null || connector === void 0 ? void 0 : connector.actionTypeId)) !== null && _getDescription !== void 0 ? _getDescription : DESCRIPTION_PLACEHOLDER,
          deleted: connector == null
        },
        label: name,
        key: name
      };
    })) !== null && _connectorNames$map !== void 0 ? _connectorNames$map : [];
  }, [aiConnectors, connectorNames, selectedConnectorNames]);
  const renderOption = (0, _react2.useCallback)(option => /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    css: (0, _react.css)`
          height: 53px;
        `,
    "data-test-subj": "connectorFilterOption",
    direction: "column",
    gutterSize: "none",
    justifyContent: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    css: (0, _react.css)`
              font-weight: bold;
            `,
    "data-test-subj": "optionLabel",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 11
    }
  }, option.label)), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    responsive: false,
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    color: option.deleted ? euiTheme.colors.textSubdued : undefined,
    "data-test-subj": "optionDescription",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 15
    }
  }, option.description)), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 13
    }
  }, option.deleted && /*#__PURE__*/_react2.default.createElement(_eui.EuiBadge, {
    css: (0, _react.css)`
                    color: ${euiTheme.colors.textDanger};
                    margin-left: ${euiTheme.size.s};
                  `,
    color: euiTheme.colors.backgroundBaseDanger,
    "data-test-subj": "deletedConnectorBadge",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 17
    }
  }, i18n.DELETED))))), [euiTheme.colors.backgroundBaseDanger, euiTheme.colors.textDanger, euiTheme.colors.textSubdued, euiTheme.size.s]);
  const button = (0, _react2.useMemo)(() => /*#__PURE__*/_react2.default.createElement(_eui.EuiFilterButton, {
    badgeColor: "subdued",
    "data-test-subj": "connectorFilterButton",
    disabled: isLoading,
    iconType: "arrowDown",
    isSelected: isPopoverOpen,
    onClick: onFilterButtonClick,
    hasActiveFilters: !!connectorFilterItems.find(item => item.checked === 'on'),
    numActiveFilters: connectorFilterItems.filter(item => item.checked === 'on').length,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 7
    }
  }, i18n.CONNECTOR), [connectorFilterItems, isLoading, isPopoverOpen, onFilterButtonClick]);
  const onSelectableChange = (0, _react2.useCallback)(newOptions => {
    const newSelectedConnectorNames = newOptions.filter(option => option.checked === 'on').map(option => option.label);
    setSelectedConnectorNames(newSelectedConnectorNames);
    invalidateFindAttackDiscoveries();
  }, [invalidateFindAttackDiscoveries, setSelectedConnectorNames]);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFilterGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiPopover, {
    button: button,
    closePopover: closePopover,
    id: filterGroupPopoverId,
    isOpen: isPopoverOpen,
    panelPaddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSelectable, {
    "aria-label": i18n.CONNECTOR,
    listProps: LIST_PROPS,
    options: connectorFilterItems,
    onChange: onSelectableChange,
    renderOption: renderOption,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 9
    }
  }, list => /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
                width: 260px;
              `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 13
    }
  }, list))));
};
ConnectorFilterComponent.displayName = 'ConnectorFilter';
const ConnectorFilter = exports.ConnectorFilter = /*#__PURE__*/_react2.default.memo(ConnectorFilterComponent);