"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.links = void 0;
var _i18n = require("@kbn/i18n");
var _translations = require("../app/translations");
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const links = exports.links = {
  capabilities: [[`${_constants.SECURITY_FEATURE_ID}.show`, `${_constants.ATTACK_DISCOVERY_FEATURE_ID}.attack-discovery`]],
  // This is an AND condition via the nested array
  globalNavPosition: 4,
  globalSearchKeywords: [_i18n.i18n.translate('xpack.securitySolution.appLinks.attackDiscovery', {
    defaultMessage: 'Attack discovery'
  })],
  id: _constants.SecurityPageName.attackDiscovery,
  licenseType: 'enterprise',
  path: _constants.ATTACK_DISCOVERY_PATH,
  title: _translations.ATTACK_DISCOVERY
};