"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFindPromptContexts = void 0;
var _elasticAssistant = require("@kbn/elastic-assistant");
var _ecsDataQualityDashboard = require("@kbn/ecs-data-quality-dashboard");
var _translations = require("../../../detection_engine/common/translations");
var _translations2 = require("../prompts/user/translations");
var _translations3 = require("../../../flyout/entity_details/shared/translations");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFindPromptContexts = payload => {
  var _prompts$find$prompt, _prompts$find, _prompts$find$prompt2, _prompts$find2, _prompts$find$prompt3, _prompts$find3, _prompts$find$prompt4, _prompts$find4, _prompts$find$prompt5, _prompts$find5;
  const {
    data: {
      prompts
    }
  } = (0, _elasticAssistant.useFindPrompts)(payload);
  const PROMPT_CONTEXTS = (0, _.getPromptContexts)({
    [_.PROMPT_CONTEXT_ALERT_CATEGORY]: (_prompts$find$prompt = (_prompts$find = prompts.find(({
      promptId
    }) => promptId === 'alertEvaluation')) === null || _prompts$find === void 0 ? void 0 : _prompts$find.prompt) !== null && _prompts$find$prompt !== void 0 ? _prompts$find$prompt : _translations2.EXPLAIN_THEN_SUMMARIZE_SUGGEST_INVESTIGATION_GUIDE,
    [_.PROMPT_CONTEXT_EVENT_CATEGORY]: (_prompts$find$prompt2 = (_prompts$find2 = prompts.find(({
      promptId
    }) => promptId === 'alertEvaluation')) === null || _prompts$find2 === void 0 ? void 0 : _prompts$find2.prompt) !== null && _prompts$find$prompt2 !== void 0 ? _prompts$find$prompt2 : _translations2.EXPLAIN_THEN_SUMMARIZE_SUGGEST_INVESTIGATION_GUIDE,
    [_.DATA_QUALITY_DASHBOARD_CATEGORY]: (_prompts$find$prompt3 = (_prompts$find3 = prompts.find(({
      promptId
    }) => promptId === 'dataQualityAnalysis')) === null || _prompts$find3 === void 0 ? void 0 : _prompts$find3.prompt) !== null && _prompts$find$prompt3 !== void 0 ? _prompts$find$prompt3 : _ecsDataQualityDashboard.DATA_QUALITY_SUGGESTED_USER_PROMPT,
    [_.PROMPT_CONTEXT_DETECTION_RULES_CATEGORY]: (_prompts$find$prompt4 = (_prompts$find4 = prompts.find(({
      promptId
    }) => promptId === 'ruleAnalysis')) === null || _prompts$find4 === void 0 ? void 0 : _prompts$find4.prompt) !== null && _prompts$find$prompt4 !== void 0 ? _prompts$find$prompt4 : _translations.EXPLAIN_THEN_SUMMARIZE_RULE_DETAILS,
    [_.PROMPT_CONTEXT_ASSET_CATEGORY]: (_prompts$find$prompt5 = (_prompts$find5 = prompts.find(({
      promptId
    }) => promptId === 'assetAnalysis')) === null || _prompts$find5 === void 0 ? void 0 : _prompts$find5.prompt) !== null && _prompts$find$prompt5 !== void 0 ? _prompts$find$prompt5 : _translations3.ASSET_INVENTORY_ENTITY_PROMPT
  });
  return PROMPT_CONTEXTS;
};
exports.useFindPromptContexts = useFindPromptContexts;